package cn.pconline.search.common.tools.generalization2;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import cn.pconline.search.common.tools.semantic2.SemanticAnalyzer;
import cn.pconline.search.common.tools.semantic2.SemanticResult;

public class DimensionPickerImpl implements DimensionPicker
{

    private Map<String, SemanticAnalyzer> analyzerMap = new HashMap<String, SemanticAnalyzer>();

    @Override
    public void addDimensionFilter(String field, SemanticAnalyzer filterAnalyzer)
    {
        analyzerMap.put(field, filterAnalyzer);
    }

    @Override
    public Dimensions pickDimensions(String input)
    {
        if (analyzerMap.isEmpty())
        {
            return null;
        }
        Dimensions dimensions = new Dimensions();
        for (Entry<String, SemanticAnalyzer> en : analyzerMap.entrySet())
        {
            SemanticResult result = en.getValue().analyze(input);
            if (result == null || !result.hasSemantic())
            {
                continue;
            }
            dimensions.addDimension(new SingleDimension(en.getKey(), result));
        }
        return dimensions;
    }

}
