package cn.pconline.search.common.util;

//${license}

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;

/**
 * 系统设置类，用于获得系统设置
 * 
 * @author chen xiaohu
 */
public class Config
{

    public static final String CONFIG_FILE = "yisou/yisou.properties";

    private static Properties config = null;

    private static byte[] lock = new byte[0];

    public static Properties config()
    {
        if (config == null)
        {
            synchronized (lock)
            {
                if (config != null)
                {
                    return config;
                }
                config = new Properties();
                InputStream is = null;
                try
                {
                    is = new FileInputStream(CONFIG_FILE);
                    config.load(is);
                }
                catch (Exception e)
                {
                    throw new RuntimeException("读取配置文件" + CONFIG_FILE + "失败!",
                            e);
                }
                finally
                {
                    if (is != null)
                    {
                        try
                        {
                            is.close();
                        }
                        catch (Exception e)
                        {
                        }
                    }
                }
            }
        }
        return config;
    }

    /**
     * 实用工具类，不能建立实例
     */
    private Config()
    {
    }

    public static void main(String[] argv)
    {
        String[] indexs = config().getProperty("indexs").split(",");
        for (int i = 0; i < indexs.length; ++i)
        {
            System.out.println(indexs[i]);
            System.out
                    .println(config().getProperty("db_" + indexs[i] + ".url"));
        }
    }

}
