package cn.pconline.search.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;

import org.apache.commons.io.IOUtils;

/**
 * 
 * <p>
 * Title:LRULinkedHashMap
 * </p>
 * <p>
 * Description:采用LRU替换策略的缓存map
 * </p>
 * 
 * @author kelly 2009-6-24 jiajiam2000@hotmail.com
 */
public class LRULinkedHashMap<K, V> extends LinkedHashMap<K, V>
{

    private static final long serialVersionUID = 8389531849280276002L;

    private final int size; // 缓存的容量

    public LRULinkedHashMap()
    {
        super();
        this.size = 16;
    }

    public LRULinkedHashMap(int size)
    {

        super(size, (float) 0.75, true);
        this.size = size;
    }

    protected boolean removeEldestEntry(Map.Entry<K, V> eldest)
    {// 缓存替换策略LRU
        return isFull();

    }

    public boolean isFull()
    { // 如果缓存溢出

        return (super.size() > this.size);
    }

    public static void main(String[] args) throws IOException
    {
        File f = new File(
                "D:/workspace1/yisou_4_0/src/cn/pconline/yisou/generalization/data");
        File[] arr = null;
        File dir = new File("c:/dest");
        if (!dir.exists())
        {
            dir.mkdir();
        }
        else
        {
            arr = dir.listFiles();
            if (arr != null)
            {
                for (File file : arr)
                {
                    if (file.isFile())
                    {
                        file.delete();
                    }
                }
            }
        }
        arr = f.listFiles();
        for (File file : arr)
        {
            if (file.getName().startsWith(".svn") || file.isDirectory())
            {
                continue;
            }
            InputStreamReader r = new InputStreamReader(new FileInputStream(
                    file), Charset.forName("gbk"));
            OutputStreamWriter w = new OutputStreamWriter(new FileOutputStream(
                    new File(dir, file.getName())), Charset.forName("UTF-8"));
            IOUtils.copy(r, w);
            r.close();
            w.close();
        }
    }
}
