package cn.pconline.search.common.query;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;

/**
 * 函数查询
 * 
 * @author zengjie
 * @since 2013-9-24
 * @see
 */
public class FunctionQuery
{

    private String functionName;

    private List<Object> params;

    public FunctionQuery(String functionName)
    {
        this.setFunctionName(functionName);
    }

    public void setParam(Object param)
    {
        if (this.params == null)
        {
            this.params = new ArrayList<Object>();
        }
        this.params.add(param);
    }

    public String getFunctionName()
    {
        return functionName;
    }

    public void setFunctionName(String functionName)
    {
        this.functionName = functionName;
    }

    @Override
    public String toString()
    {
        StringBuilder sb = new StringBuilder();
        sb.append(functionName);
        sb.append("(");
        if (CollectionUtils.isNotEmpty(params))
        {
            for (int i = 0, size = params.size(); i < size; i++)
            {
                if (i > 0)
                {
                    sb.append(",");
                }
                sb.append(params.get(i));
            }
        }
        sb.append(")");
        return sb.toString();
    }
}
