package cn.pconline.search.common.taglib;

import javax.servlet.jsp.JspException;

/**
 * 通用分页标签
 * 
 * @author zengjie
 * @since 2013-9-17
 * @see
 */
public class CommonPagerTag extends BaseTag
{

    private static final long serialVersionUID = -6421737674756807494L;

    private Integer lastCount;

    private String currentPage;

    private Integer pageNo;

    /**
     * 上一页按钮样式
     */
    private String prevClass = "prev";

    /**
     * 下一页按钮样式
     */
    private String nextClass = "next";

    @Override
    public int doStartTag() throws JspException
    {
        if (lastCount > 0)
        {
            String aUrl = currentPage;
            if (pageNo > 0)
            {
                HtmlTag pre = new HtmlTag("a", new HtmlText("上一页"));
                pre.addAttribute("href", aUrl + "&pageNo=" + pageNo);
                pre.addAttribute("target", "_self");
                pre.addAttribute("class", prevClass);
                writeToOut(pre);
                HtmlTag first = new HtmlTag("a", new HtmlText(1));
                first.addAttribute("target", "_self");
                pre.addAttribute("href", aUrl);
                writeToOut(first);
            }
            else
            {
                writeToOut(new HtmlTag("span", new HtmlText(1)));
            }
            if (pageNo - 3 > 1 && lastCount > 8)
            {
                writeToOut("...");
                int startPage = Math.max(pageNo - 3, 1);
                int endPage = Math.max(pageNo + 3, 7);
                endPage = Math.min(endPage, lastCount - 1);
                if (endPage - pageNo < 3)
                {
                    int addNum = 3 - (endPage - pageNo - 1);
                    startPage = Math.max(startPage - addNum + 1, 1);
                }
                for (int i = startPage; i <= endPage; i++)
                {
                    if (pageNo == i)
                    {
                        writeToOut(new HtmlTag("span", new HtmlText(i + 1)));
                    }
                    else
                    {
                        HtmlTag link = new HtmlTag("a", new HtmlText(i + 1));
                        link.addAttribute("HREF", aUrl + "\"&pageNo=" + (i + 1));
                        writeToOut(link);
                    }
                }

                if (pageNo + 4 < lastCount && lastCount > 8)
                {
                    writeToOut("...");
                }
                if (pageNo < lastCount)
                {
                    HtmlTag link = new HtmlTag("a", new HtmlText(lastCount + 1));
                    link.addAttribute("href", aUrl + "&pageNo="
                            + (lastCount + 1));
                    link.addAttribute("target", "_self");
                    writeToOut(link);
                    link = new HtmlTag("a", new HtmlText("下一页"));
                    link.addAttribute("href", aUrl + "&pageNo=" + (pageNo + 2));
                    link.addAttribute("target", "_self");
                    link.addAttribute("class", nextClass);
                    writeToOut(link);

                }
                else
                {
                    writeToOut(new HtmlTag("span", new HtmlText(lastCount + 1)));
                }
            }
        }
        return EVAL_BODY_INCLUDE;
    }

    public void setLastCount(Integer lastCount)
    {
        this.lastCount = lastCount;
    }

    public void setCurrentPage(String currentPage)
    {
        this.currentPage = currentPage;
    }

    public void setPageNo(Integer pageNo)
    {
        this.pageNo = pageNo;
    }

    public void setPrevClass(String prevClass)
    {
        this.prevClass = prevClass;
    }

    public void setNextClass(String nextClass)
    {
        this.nextClass = nextClass;
    }

}
