package cn.pconline.search.common.taglib;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class HtmlTag
{

    private Map<String, String> attrs;

    private List<HtmlTag> childs;

    private String tagName;

    public HtmlTag()
    {
    }

    public HtmlTag(String tagName)
    {
        super();
        this.tagName = tagName;
    }

    public HtmlTag(String tagName, HtmlText body)
    {
        super();
        this.tagName = tagName;
        this.addChild(body);
    }

    public void addAttribute(String key, String value)
    {
        if (attrs == null)
        {
            attrs = new HashMap<String, String>();
        }
        attrs.put(key, value);
    }

    public void addChild(HtmlTag tag)
    {
        if (childs == null)
        {
            childs = new ArrayList<HtmlTag>();
        }
        childs.add(tag);
    }

    public Map<String, String> getAttrs()
    {
        return attrs;
    }

    public void setAttrs(Map<String, String> attrs)
    {
        this.attrs = attrs;
    }

    public List<HtmlTag> getChilds()
    {
        return childs;
    }

    public String getTagName()
    {
        return tagName;
    }

    @Override
    public String toString()
    {
        StringBuilder builder = new StringBuilder();

        builder.append("<").append(tagName);
        if (MapUtils.isNotEmpty(attrs))
        {
            for (Entry<String, String> en : attrs.entrySet())
            {
                builder.append(" ");
                builder.append(en.getKey());
                builder.append("=\"");
                builder.append(en.getValue());
                builder.append("\" ");
            }
        }
        if (CollectionUtils.isEmpty(childs))
        {
            builder.append("/>");
        }
        else
        {
            builder.append(">");
            for (HtmlTag tag : childs)
            {
                builder.append(tag);
            }
            builder.append("</").append(tagName).append(">");
        }
        return builder.toString();
    }
}
