package cn.pconline.search.common.tools.price;

/**
 * 表示一个从语句中提取出来的价格范围的对象
 * <p>
 * 使用千调用 {@link PriceRange#isEmptyRange()}判断是否为空范围
 * </p>
 * 
 * @author zengjie
 * @since 2013-9-16
 * @see
 */
public class PriceRange
{

    private Double upValue;

    private Double lowValue;

    private StringBuilder otherQuery;

    public Double getUpValue()
    {
        return upValue;
    }

    public void setUpValue(Double upValue)
    {
        this.upValue = upValue;
    }

    public Double getLowValue()
    {
        return lowValue;
    }

    public void setLowValue(Double lowValue)
    {
        this.lowValue = lowValue;
    }

    public String getOtherQuery()
    {
        if (otherQuery == null)
        {
            return null;
        }
        return otherQuery.toString();
    }

    public void appendOtherQuery(Object q)
    {
        if (this.otherQuery == null)
        {
            otherQuery = new StringBuilder();
        }
        this.otherQuery.append(q);
    }

    public String toString()
    {
        return "[" + lowValue + " TO " + upValue + "] otherQuery:" + otherQuery;
    }

    public boolean isEmptyRange()
    {
        return upValue == null && lowValue == null;
    }

}
