package cn.pconline.search.common.tools.semantic2;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

import org.apache.commons.io.IOUtils;

/**
 * 文件资源字典
 * 
 * @author zengjie
 * @since 2013-9-11
 * @see
 */
public class FileResourceDict implements DictWordIterator
{

    private String charset;

    private String resource;

    private BufferedReader reader;

    private boolean inited;

    private boolean EOF = false;

    public FileResourceDict(String charset, String resource)
    {
        super();
        this.charset = charset;
        this.resource = resource;
    }

    @Override
    public DictWord next()
    {
        if (!inited)
        {
            InputStream in = FileResourceDict.class.getClassLoader()
                    .getResourceAsStream(resource);
            if (in != null)
            {
                reader = new BufferedReader(new InputStreamReader(in,
                        Charset.forName(charset)));
            }
            inited = true;
        }
        if (reader == null)
        {
            return null;
        }
        if (EOF)
        {
            return null;
        }
        String line = null;
        try
        {
            line = reader.readLine();
        }
        catch (IOException e)
        {
            EOF = true;
            return null;
        }
        if (line == null)
        {
            EOF = true;
            return null;
        }
        DictWord word = new DictWord();
        word.setWord(line);
        return word;
    }

    @Override
    public void close()
    {
        IOUtils.closeQuietly(reader);
    }

}
