package cn.pconline.search.common.util;

import java.util.*;
import java.io.*;

import javax.mail.*;
import javax.mail.internet.*;
import javax.activation.*;

/**
 * 
 * <p>
 * Title:SendMail
 * </p>
 * <p>
 * Description:发送邮件
 * </p>
 * 
 * @author kelly 2009-4-9 jiajiam2000@hotmail.com
 */
public class SendMail
{

    /**
     * 要发送Mail地址
     */
    private String mailTo = null;

    /**
     * Mail发送的起始地址
     */
    private String mailFrom = null;

    /**
     * SMTP主机地址
     */
    private String smtpHost = null;

    /**
     * 是否采用调试方式
     */
    private boolean debug = false;

    private String messageBasePath = null;

    /**
     * Mail主题
     */
    private String subject;

    /**
     * Mail内容
     */
    private String msgContent;

    /**
     * 设置发件人名称
     */
    private String mailPersonal = null;

    /**
     * 访问认证
     */
    private MailAuthenticator auth = null;

    private ArrayList<String> attachedFileList = null;

    private String mailAccount = null;

    private String mailPass = null;

    private String messageContentMimeType = "text/html; charset=gb2312";

    private String mailbccTo = null;

    private String mailccTo = null;

    private void fillMail(Session session, MimeMessage msg) throws IOException,
            MessagingException
    {

        String fileName = null;
        Multipart mPart = new MimeMultipart();
        if (mailFrom != null)
        {
            msg.setFrom(new InternetAddress(mailFrom, mailPersonal));
        }
        else
        {
            System.out.println("没有指定发送人邮件地址！");
            return;
        }
        if (mailTo != null)
        {
            InternetAddress[] address = InternetAddress.parse(mailTo);
            msg.setRecipients(Message.RecipientType.TO, address);
        }
        else
        {
            System.out.println("没有指定收件人邮件地址！");
            return;
        }

        if (mailccTo != null)
        {
            InternetAddress[] ccaddress = InternetAddress.parse(mailccTo);
            msg.setRecipients(Message.RecipientType.CC, ccaddress);
        }
        if (mailbccTo != null)
        {
            InternetAddress[] bccaddress = InternetAddress.parse(mailbccTo);
            msg.setRecipients(Message.RecipientType.BCC, bccaddress);
        }
        msg.setSubject(subject);
        InternetAddress[] replyAddress = { new InternetAddress(mailFrom) };
        msg.setReplyTo(replyAddress);
        // create and fill the first message part
        MimeBodyPart mBodyContent = new MimeBodyPart();
        if (msgContent != null) mBodyContent.setContent(msgContent,
                messageContentMimeType);
        else mBodyContent.setContent("", messageContentMimeType);
        mPart.addBodyPart(mBodyContent);
        // attach the file to the message
        if (attachedFileList != null)
        {
            for (int i = 0; i < attachedFileList.size(); i++)
            {
                fileName = attachedFileList.get(i);
                MimeBodyPart mBodyPart = new MimeBodyPart();
                // attach the file to the message
                FileDataSource fds = new FileDataSource(messageBasePath
                        + fileName);
                mBodyPart.setDataHandler(new DataHandler(fds));
                mBodyPart.setFileName(fileName);
                mPart.addBodyPart(mBodyPart);
            }

        }
        msg.setContent(mPart);
        msg.setSentDate(new Date());
    }

    /**
     * 此处插入方法说明。
     */
    public void init()
    {

    }

    /**
     * 发送e_mail，返回类型为int 当返回值为0时，说明邮件发送成功 当返回值为3时，说明邮件发送失败
     * 
     * @param isAuth
     *            ：是否需验证
     * @return
     * @throws IOException
     * @throws MessagingException
     *             int
     * @author kelly 2009-4-27
     */
    public int sendMail(boolean isAuth) throws IOException, MessagingException
    {

        Properties props = System.getProperties();
        props.put("mail.smtp.host", smtpHost);
        props.put("mail.smtp.auth", isAuth);
        Session session = Session.getInstance(props, auth);
        session.setDebug(debug);
        MimeMessage msg = new MimeMessage(session);
        Transport trans = null;
        try
        {
            fillMail(session, msg);
            // send the message
            trans = session.getTransport("smtp");
            if (auth != null)
            {
                try
                {
                    trans.connect(smtpHost, auth.mailUser, auth.mailPassWord);
                }
                catch (AuthenticationFailedException e)
                {
                    e.printStackTrace();
                    System.out.println("连接邮件服务器错误：" + e.getMessage());
                    return 3;
                }
                catch (MessagingException e)
                {
                    e.printStackTrace();
                    System.out.println("连接邮件服务器错误：" + e.getMessage());
                    return 3;
                }
            }
            else if (isAuth)
            {
                System.out.println("缺少邮件注册认证");
                // trans.connect();
                return 3;
            }
            trans.send(msg);
            trans.close();

        }
        catch (MessagingException mex)
        {
            System.out.println("发送邮件失败：");
            mex.printStackTrace();
            Exception ex = null;
            if ((ex = mex.getNextException()) != null)
            {
                ex.printStackTrace();
            }
            return 3;
        }
        finally
        {
            try
            {
                if (trans != null && trans.isConnected()) trans.close();
            }
            catch (Exception e)
            {
                System.out.println(e.toString());
            }
        }
        return 0;
    }

    public void setAttachedFileList(ArrayList<String> filelist)
    {
        attachedFileList = filelist;
    }

    public void setDebug(boolean debugFlag)
    {
        debug = debugFlag;
    }

    public void setMailAccount(String strAccount)
    {
        mailAccount = strAccount;
    }

    public void setMailbccTo(String bccto)
    {
        mailbccTo = bccto;
    }

    public void setMailccTo(String ccto)
    {
        mailccTo = ccto;
    }

    public void setMailFrom(String from)
    {
        mailFrom = from;
    }

    public void setMailPass(String strMailPass)
    {
        mailPass = strMailPass;
    }

    public void setMailTo(String to)
    {
        mailTo = to;
    }

    public void setMessageBasePath(String basePath)
    {
        messageBasePath = basePath;
    }

    public void setMessageContentMimeType(String mimeType)
    {
        messageContentMimeType = mimeType;
    }

    public void setMsgContent(String content)
    {
        msgContent = content;
    }

    public void setSMTPHost(String host)
    {
        smtpHost = host;
    }

    public void setSubject(String sub)
    {
        subject = sub;
    }

    public String getMailPersonal()
    {
        return mailPersonal;
    }

    public void setMailPersonal(String mailPersonal)
    {
        this.mailPersonal = mailPersonal;
    }

    public MailAuthenticator getAuth()
    {
        return auth;
    }

    public void setAuth(MailAuthenticator auth)
    {
        this.auth = auth;
    }

}
