package cn.pconline.search.common.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;

/**
 * 公用WebController
 * 
 * @author zengjie
 * @since 2013-9-18
 * @see
 */
public class CommonController
{

    /**
     * 是否包含指定敏感词
     * 
     * @param query
     * @param words
     * @return
     */
    public static boolean hasSensitiveWord(String query, String... words)
    {
        if (StringUtils.isBlank(query))
        {
            return false;
        }
        for (String word : words)
        {
            if (query.contains(word))
            {
                return true;
            }
        }
        return false;
    }

    /**
     * 设置HTTP客户端缓存
     * 
     * @param rsp
     * @param timeToExpire
     */
    public static void setHttpCache(HttpServletResponse rsp, long timeToExpire)
    {
        rsp.setDateHeader("Expires", System.currentTimeMillis() + timeToExpire);
    }

    public static String getStringParam(HttpServletRequest req, String key,
            String def)
    {
        String value = req.getParameter(key);
        if (value == null)
        {
            return def;
        }
        return value;
    }

    public static Integer getIntParam(HttpServletRequest req, String key,
            Integer def)
    {
        String value = req.getParameter(key);
        if (value == null)
        {
            return def;
        }
        try
        {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e)
        {
            return def;
        }
    }
    
}
