package cn.pconline.search.common;

/**
 * 表示获取搜索配置相关的接口
 * 
 * @author zengjie
 * @since 2013-9-22
 * @see
 */
public interface Configuration
{

    /**
     * 获取字符串框架配置
     * 
     * @param key
     * @param def
     * @return
     */
    public String getConfig(String key, String def);

    public String getConfig(String key);

    /**
     * 获取integer框架配置
     * 
     * @param key
     * @param def
     * @return
     */
    public Integer getIntConfig(String key, Integer def);

    public Integer getIntConfig(String key);

    /**
     * 获取boolean值参数
     * 
     * @param key
     * @param def
     * @return
     */
    public Boolean getBooleanConfig(String key, Boolean def);

    public Boolean getBooleanConfig(String key);

    /**
     * 一些常用的配置项KEY名称
     * 
     * @author zengjie
     * @since 2013-9-22
     * @see
     */
    public interface ConfigConstant
    {

        String SOLR_SERVER_URL = "solrServerUrl";

        String SEARCH_CONNECT_TIMEOUT = "searchConnectTimeout";

        String SEARCH_SOCKET_TIMEOUT = "searchSoTimeout";
    }
}
