package cn.pconline.search.common.query;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;

/**
 * 表示一个查询语句对象
 * 
 * @author zengjie
 * @since 2013-9-24
 * @see
 */
public class Q
{

    private List<Condition> conditions;

    private FunctionQuery functionQuery;

    private NestedQuery nestedQuery;

    public List<Condition> getConditions()
    {
        return conditions;
    }

    public void addCondition(Condition condition)
    {
        if (this.conditions == null)
        {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(condition);
    }

    public FunctionQuery getFunctionQuery()
    {
        return functionQuery;
    }

    public void setFunctionQuery(FunctionQuery functionQuery)
    {
        this.functionQuery = functionQuery;
    }

    public NestedQuery getNestedQuery()
    {
        return nestedQuery;
    }

    public void setNestedQuery(NestedQuery nestedQuery)
    {
        this.nestedQuery = nestedQuery;
    }

    @Override
    public String toString()
    {
        StringBuilder sb = new StringBuilder();
        if (nestedQuery != null)
        {
            sb.append(nestedQuery);
        }
        if (functionQuery != null)
        {
            sb.append(" _val_:\"").append(functionQuery).append("\"");
        }
        if (CollectionUtils.isNotEmpty(conditions))
        {
            for (Condition c : conditions)
            {
                sb.append(c).append(" ");
            }
        }
        return sb.toString();
    }

    public static void main(String[] args)
    {
        Q q = new Q();
        NestedQuery nq = new NestedQuery();
        nq.setDefType("lucene");
        nq.set("qf", "title^10 summary^0.1 keyword^0.1");
        Q q1 = new Q();
        q1.addCondition(new Condition("status", Operator.MUST, "p"));
        nq.setQ("汽车");
        q.setNestedQuery(nq);
        System.out.println(q);
    }
}
