/* Generated By:JavaCC: Do not edit this line. PriceExtractor.java */
package cn.pconline.search.common.tools.price;

import cn.pconline.search.common.util.Cache;
import java.io.*;
import org.apache.log4j.Logger;

public class PriceExtractor implements PriceExtractorConstants {

        private static Cache cache = new Cache(1000);

        private static Logger logger = Logger.getLogger(PriceExtractor.class);

    private PriceRange range = null;

    private StringBuilder tempBuilder = new StringBuilder();

    public PriceExtractor(String input)
    {
        this(new StringReader(input));
    }

    private double productNum(double product, double base)
        {
        if (base == 0)
        {
            return product;
        }
        return product * base;
        }

        private void setRangeValue(boolean isUpperValue,double value)
        {
        if(isUpperValue)
        {
            if(range.getUpValue() == null || range.getUpValue().doubleValue() >= value)
            {
                range.setUpValue(value);
                return;
            }
        }
        else
        {
            if(range.getLowValue() == null || range.getLowValue().doubleValue() <= value)
            {
                range.setLowValue(value);
                return;
            }
        }
        }

        private void appendTemp(Object value)
        {
            tempBuilder.append(value);
        }

        private String clearTemp()
        {
            String v = tempBuilder.toString();
            if(tempBuilder.length() > 0)
            {
                tempBuilder.delete(0,tempBuilder.length());
                }
                return v;
        }

        public static final PriceRange getPriceRange(String input)
        {
            PriceRange range = (PriceRange)cache.get(input);
            if(range != null)
            {
                return range;
            }
            PriceExtractor extractor = new PriceExtractor(input);
            try
            {
                range = extractor.extract();
                if(range == null)
                {
                    cache.add(input,new PriceRange());
                }else
                {
                        cache.add(input,range);
                        }
                return range;
            }
            catch(Exception e)
            {
                logger.error("extract price error" , e);
                return null;
            }
        }

        protected double getPriceValue(double parsedPrice)
        {
            return parsedPrice;
        }

  final private PriceRange extract() throws ParseException {
    Token t;
    boolean sucess = false;
    range = new PriceRange();
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 0:
      case SPACE:
      case NUMBER:
      case CONSTANT:
      case WAN:
      case QIAN:
      case BAI:
      case SHI:
      case YI:
      case ER:
      case SAN:
      case SI:
      case WU:
      case LIU:
      case QI:
      case BA:
      case JIU:
      case UPPER:
      case LOWER:
      case OTHER:
        ;
        break;
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        jj_consume_token(SPACE);
                            range.appendOtherQuery(" ");
        break;
      default:
        jj_la1[2] = jj_gen;
        label_2:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case OTHER:
            ;
            break;
          default:
            jj_la1[1] = jj_gen;
            break label_2;
          }
          t = jj_consume_token(OTHER);
                                range.appendOtherQuery(t);
        }
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 0:
        jj_consume_token(0);
                        {if (true) return range;}
        break;
      case SPACE:
      case NUMBER:
      case CONSTANT:
      case WAN:
      case QIAN:
      case BAI:
      case SHI:
      case YI:
      case ER:
      case SAN:
      case SI:
      case WU:
      case LIU:
      case QI:
      case BA:
      case JIU:
      case OTHER:
        sucess = getDoubleRange();
                            if(sucess)
                            {
                                clearTemp();
                            }
                            else
                            {
                                range.appendOtherQuery(clearTemp());
                            }
        break;
      case UPPER:
      case LOWER:
        sucess = getSingleRange();
                            if(sucess)
                            {
                                clearTemp();
                            }
                            else
                            {
                                range.appendOtherQuery(clearTemp());
                            }
        break;
      default:
        jj_la1[3] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                    if(sucess)
                    {
                        range.appendOtherQuery(" ");
                        }
      label_3:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OTHER:
          ;
          break;
        default:
          jj_la1[4] = jj_gen;
          break label_3;
        }
        t = jj_consume_token(OTHER);
                        range.appendOtherQuery(t);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final private boolean getSingleRange() throws ParseException {
    Token t;
    boolean isUpper = false;
    double price = 0;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UPPER:
      t = jj_consume_token(UPPER);
                        appendTemp(t);
                        isUpper = false;
      break;
    case LOWER:
      t = jj_consume_token(LOWER);
                            appendTemp(t);
                            isUpper = true;
      break;
    default:
      jj_la1[5] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    price = getTargetPrice(true);
                if (price != 0)
                {
                    setRangeValue(isUpper,price);
                    {if (true) return true;}
                }
            {if (true) return false;}
    throw new Error("Missing return statement in function");
  }

  final private boolean getDoubleRange() throws ParseException {
    double price = 0;
    Token t;
    price = getTargetPrice(false);
            if (price == 0)
            {
                {if (true) return false;}
            }
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OTHER:
        ;
        break;
      default:
        jj_la1[6] = jj_gen;
        break label_4;
      }
      findOther();
        {if (true) return false;}
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SPACE:
    case DOUBLE_RANGE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        findSpace();
        break;
      default:
        jj_la1[7] = jj_gen;
        ;
      }
      t = jj_consume_token(DOUBLE_RANGE);
                        appendTemp(t);
                        setRangeValue(false,price);
      price = getTargetPrice(true);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 23:
      case 24:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 23:
          t = jj_consume_token(23);
          break;
        case 24:
          jj_consume_token(24);
                        appendTemp(t);
          break;
        default:
          jj_la1[8] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[9] = jj_gen;
        ;
      }
                        if (price == 0)
                        {
                            {if (true) return false;}
                        }
                        setRangeValue(true,price);
                        {if (true) return true;}
      break;
    case 25:
      //以上
                  t = jj_consume_token(25);
                appendTemp(t);
                setRangeValue(false,price);
                {if (true) return true;}
      break;
    case 26:
    case 27:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 26:
        t = jj_consume_token(26);
        break;
      case 27:
        t = jj_consume_token(27);
        break;
      default:
        jj_la1[10] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                    appendTemp(t);
                    setRangeValue(true,price);
                    {if (true) return true;}
      break;
    case 28:
    case 29:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 28:
        t = jj_consume_token(28);
                                appendTemp(t);
        break;
      case 29:
        t = jj_consume_token(29);
                                appendTemp(t);
        break;
      default:
        jj_la1[11] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                            setRangeValue(true,price + price * 0.2);
                            setRangeValue(false,price - price * 0.2);
                            {if (true) return true;}
      break;
    default:
      jj_la1[12] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
            {if (true) return false;}
    throw new Error("Missing return statement in function");
  }

  final private double getTargetPrice(boolean allowOther) throws ParseException {
    Token t;
    double numValue = 0;
    double numBase = 0;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OTHER:
      findOther();
                {if (true) return 0;}
      break;
    default:
      jj_la1[14] = jj_gen;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        findSpace();
        break;
      default:
        jj_la1[13] = jj_gen;
        ;
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NUMBER:
    case CONSTANT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NUMBER:
        t = jj_consume_token(NUMBER);
        break;
      case CONSTANT:
        t = jj_consume_token(CONSTANT);
        break;
      default:
        jj_la1[15] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                    numValue = Double.parseDouble(t.image);
                    appendTemp(t);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        findSpace();
        break;
      default:
        jj_la1[16] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WAN:
      case QIAN:
      case BAI:
      case SHI:
        numBase = getNumBase();
                        if(numBase > 0)
                        {
                                numValue *= numBase;
                        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NUMBER:
          t = jj_consume_token(NUMBER);
                                    if(numBase > 0)
                                {
                                         numValue += Double.parseDouble(t.image)/10 * numBase;
                                }
                                    appendTemp(t);
          break;
        default:
          jj_la1[17] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[18] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        findSpace();
        break;
      default:
        jj_la1[19] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CURRENCY_UNIT:
        getCurrecyUnit();
        break;
      default:
        jj_la1[20] = jj_gen;
        ;
      }
      break;
    case WAN:
    case QIAN:
    case BAI:
    case SHI:
      label_5:
      while (true) {
        numBase = getNumBase();
                        if(numBase > 0)
                        {
                                numValue = productNum(numBase, numValue);
                        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WAN:
        case QIAN:
        case BAI:
        case SHI:
          ;
          break;
        default:
          jj_la1[21] = jj_gen;
          break label_5;
        }
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        findSpace();
        break;
      default:
        jj_la1[22] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CURRENCY_UNIT:
        getCurrecyUnit();
        break;
      default:
        jj_la1[23] = jj_gen;
        ;
      }
      break;
    case YI:
    case ER:
    case SAN:
    case SI:
    case WU:
    case LIU:
    case QI:
    case BA:
    case JIU:
      numValue = getChineseNum();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        findSpace();
        break;
      default:
        jj_la1[24] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CURRENCY_UNIT:
        getCurrecyUnit();
        break;
      default:
        jj_la1[25] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[26] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return getPriceValue(numValue);}
    throw new Error("Missing return statement in function");
  }

  final private void findSpace() throws ParseException {
    jj_consume_token(SPACE);
            appendTemp(" ");
  }

  final private void findOther() throws ParseException {
    Token t;
    t = jj_consume_token(OTHER);
       appendTemp(t);
  }

  final private void getCurrecyUnit() throws ParseException {
        Token t;
    t = jj_consume_token(CURRENCY_UNIT);
                appendTemp(t);
  }

  final private int getNumBase() throws ParseException {
        Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WAN:
      t = jj_consume_token(WAN);
                appendTemp(t);
                {if (true) return 10000;}
      break;
    case QIAN:
      t = jj_consume_token(QIAN);
                appendTemp(t);
                {if (true) return 1000;}
      break;
    case BAI:
      t = jj_consume_token(BAI);
                appendTemp(t);
                {if (true) return 100;}
      break;
    case SHI:
      t = jj_consume_token(SHI);
                appendTemp(t);
                {if (true) return 10;}
      break;
    default:
      jj_la1[27] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return 0;}
    throw new Error("Missing return statement in function");
  }

  final private double getChineseNum() throws ParseException {
    double num = 0;
    double baseNum = 0;
    Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case YI:
      t = jj_consume_token(YI);
      break;
    case ER:
      t = jj_consume_token(ER);
                num = productNum(2, num);
      break;
    case SAN:
      t = jj_consume_token(SAN);
                num = productNum(3, num);
      break;
    case SI:
      t = jj_consume_token(SI);
                num = productNum(4, num);
      break;
    case WU:
      t = jj_consume_token(WU);
                num = productNum(5, num);
      break;
    case LIU:
      t = jj_consume_token(LIU);
                num = productNum(6, num);
      break;
    case QI:
      t = jj_consume_token(QI);
                num = productNum(7, num);
      break;
    case BA:
      t = jj_consume_token(BA);
                num = productNum(8, num);
      break;
    case JIU:
      t = jj_consume_token(JIU);
                num = productNum(9, num);
      break;
    default:
      jj_la1[28] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
            appendTemp(t);
    baseNum = getNumBase();
            num = productNum(baseNum, num);
        {if (true) return num;}
    throw new Error("Missing return statement in function");
  }

  /** Generated Token Manager. */
  public PriceExtractorTokenManager token_source;
  JavaCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[29];
  static private int[] jj_la1_0;
  static {
      jj_la1_init_0();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x5ffdef,0x400000,0x2,0x5ffdef,0x400000,0x180000,0x400000,0x2,0x1800000,0x1800000,0xc000000,0x30000000,0x3e200002,0x2,0x400000,0xc,0x2,0x4,0x1e0,0x2,0x200,0x1e0,0x2,0x200,0x2,0x200,0x7fdec,0x1e0,0x7fc00,};
   }

  /** Constructor with InputStream. */
  public PriceExtractor(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public PriceExtractor(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new JavaCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new PriceExtractorTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 29; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 29; i++) jj_la1[i] = -1;
  }

  /** Constructor. */
  public PriceExtractor(java.io.Reader stream) {
    jj_input_stream = new JavaCharStream(stream, 1, 1);
    token_source = new PriceExtractorTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 29; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 29; i++) jj_la1[i] = -1;
  }

  /** Constructor with generated Token Manager. */
  public PriceExtractor(PriceExtractorTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 29; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(PriceExtractorTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 29; i++) jj_la1[i] = -1;
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[30];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 29; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 30; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

}
