package cn.pconline.search.common.tools.segment.utility;

/**
 * 数字相关的工具类
 * 
 */
public class NumUtil {
	/**
	 * 字符串的所有单个字符都是数字但本身并不是一个有意义的数字
	 * 
	 * @param str
	 * @return
	 */
	public static boolean isNumStrNotNum(String word) {
		if (word != null && word.length()==1 && Utility.isInAggregate("几数第上成±—＋∶·．／+-./", word)) {
			return true;
		}
		return false;
	}

	/**
	 * 是否是数字、连字符的情况，如：３-4月
	 * 
	 * @param pos
	 * @param str
	 * @return
	 */
	public static boolean isNumDelimiter(int pos, String str) {
		if (str != null && str.length() > 1) {
			String first = str.substring(0, 1);
			// //27904='m'*256 29696='t'*256
			if ((Math.abs(pos) == POSTag.NUM || Math.abs(pos) == POSTag.TIME)
					&& ("—".equals(first) || "-".equals(first)))
				return true;
		}
		return false;
	}

}
