/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common;

import cn.pconline.search.common.Configuration;
import cn.pconline.search.common.SolrSearcher;
import cn.pconline.search.common.log.SearchLogger;
import cn.pconline.search.common.tools.homonym.Homonyms;
import cn.pconline.search.common.tools.sensitive.AnalyzeSensitiveFilter;
import cn.pconline.search.common.tools.sensitive.SensitiveFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SearchFrame {
    private volatile boolean inited = false;
    private static Logger logger = Logger.getLogger(SearchFrame.class);
    protected Configuration configuration;
    private SearchLogger searchLogger;
    private SolrSearcher searcher;
    private Homonyms homonyms;
    private SensitiveFilter sensitiveFilter;
    private static SearchFrame instance = new SearchFrame();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Configuration config) {
        if (!this.inited) {
            SearchFrame searchFrame = this;
            synchronized (searchFrame) {
                if (this.inited) {
                    return;
                }
                long start = System.currentTimeMillis();
                logger.debug((Object)("Init SearchFrame with config{" + config + "}"));
                if (config.getBooleanConfig("enableSearchLog", true).booleanValue()) {
                    this.searchLogger = new SearchLogger(config);
                }
                this.searcher = new SolrSearcher(config);
                String homonymsFiles = config.getConfig("homonymsFiles", null);
                if (StringUtils.isNotBlank((String)homonymsFiles)) {
                    this.homonyms = new Homonyms(homonymsFiles);
                }
                if (config.getBooleanConfig("enbaleSensitiveFilter", true).booleanValue()) {
                    this.sensitiveFilter = new AnalyzeSensitiveFilter(config);
                    logger.debug((Object)"finish load SensitiveFilter");
                }
                logger.debug((Object)("SearchFrame init complete in " + (System.currentTimeMillis() - start) + " ms"));
                this.inited = true;
            }
        }
    }

    private SearchFrame() {
    }

    private void checkInit() {
        if (!this.inited) {
            throw new IllegalStateException("Frame has not been initialize or has been closed,pelease make sure has invoked #init# method");
        }
    }

    public static SearchFrame get() {
        return instance;
    }

    public SearchLogger getLogger() {
        this.checkInit();
        if (this.searchLogger == null) {
            throw new IllegalStateException("SearchLogger is not enable");
        }
        return this.searchLogger;
    }

    public SolrSearcher getSearcher() {
        this.checkInit();
        return this.searcher;
    }

    public Homonyms getHomonyms() {
        this.checkInit();
        return this.homonyms;
    }

    public String getHomonynsWords(String key) {
        this.checkInit();
        if (this.homonyms == null) {
            return "";
        }
        return this.homonyms.getHomonyms(key);
    }

    public SensitiveFilter getSensitiveFilter() {
        this.checkInit();
        if (this.sensitiveFilter == null) {
            throw new IllegalStateException("sensitive filter is not enable or load fail");
        }
        return this.sensitiveFilter;
    }

    public void shutdown() {
        if (!this.inited) {
            return;
        }
        try {
            this.searcher.close();
            this.searcher = null;
            if (this.searchLogger != null) {
                this.searchLogger.close();
            }
            this.searchLogger = null;
            this.homonyms = null;
        }
        finally {
            this.inited = false;
        }
    }

    public boolean isAvaliable() {
        return this.inited;
    }
}

