/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.tools.segment.utility;

import cn.pconline.search.common.tools.segment.bean.POS;
import cn.pconline.search.common.tools.segment.bean.SegNode;
import cn.pconline.search.common.tools.segment.bean.SegResult;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

public class DebugUtil {
    public static void output2html(SegResult sr) {
        if (sr != null) {
            try {
                String html = "<html><head><title>ictclas4j\u5206\u8bcd\u7ed3\u679c</title></head>";
                html = String.valueOf(html) + "<body bgcolor=\"#CCFF99\">";
                html = String.valueOf(html) + sr.toHTML();
                html = String.valueOf(html) + "</body></html>";
                DebugUtil.writeTxtFile("output\\sr.html", html, false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void outputPostag(ArrayList<SegNode> sns) {
        if (sns != null) {
            try {
                StringBuffer html = new StringBuffer();
                html.append("<html><head><title>ictclas4j\u5206\u8bcd\u7ed3\u679c</title></head>");
                html.append("<body bgcolor=\"#CCFF99\">");
                html.append("<p>\u8fdb\u884c\u539f\u5b50\u5206\u8bcd\u540e\u7684\u7ed3\u679c\uff1a");
                html.append("<table border=\"1\" width=\"100%\">");
                for (SegNode sn : sns) {
                    html.append("<tr>");
                    html.append("<td width=\"10%\" bgcolor=\"#99CCFF\"  rowspan=\"" + sn.getPosSize() + "\">" + sn.getWord() + "</td>");
                    ArrayList<POS> allPos = sn.getAllPos();
                    boolean flag = false;
                    for (POS pos : allPos) {
                        if (flag) {
                            html.append("<tr>");
                        }
                        html.append("<td width=\"20%\" >" + pos.getTag() + "</td>");
                        html.append("<td width=\"20%\" >" + pos.getFreq() + "</td>");
                        html.append("<td width=\"20%\" >" + pos.getPrev() + "</td>");
                        String sBest = pos.isBest() ? "true" : "&nbsp";
                        html.append("<td width=\"20%\" >" + sBest + "</td>");
                        html.append("</tr>");
                        if (flag) continue;
                        flag = true;
                    }
                }
                html.append("</table>");
                html.append("</body></html>");
                DebugUtil.writeTxtFile("output\\postag.html", html.toString(), false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void output2gui(SegResult sr) {
    }

    public static boolean writeTxtFile(String fileName, String txt, boolean isAppend) throws IOException {
        FileWriter fw = null;
        PrintWriter out = null;
        if (fileName != null && txt != null) {
            try {
                File fp;
                String parent;
                File file = new File(fileName);
                if (!file.exists() && (parent = file.getParent()) != null && !(fp = new File(parent)).isDirectory()) {
                    fp.mkdirs();
                }
                String[] msgs = txt.split("\n");
                fw = new FileWriter(file, isAppend);
                out = new PrintWriter(fw);
                int i = 0;
                while (i < msgs.length) {
                    out.println(msgs[i]);
                    ++i;
                }
                out.flush();
                out.close();
                return true;
            }
            catch (IOException e) {
                throw new IOException();
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        return false;
    }
}

