/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.tools.semantic2;

import cn.pconline.search.common.tools.semantic2.DictWord;
import cn.pconline.search.common.tools.semantic2.DictWordIterator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;

public class FileResourceDict
implements DictWordIterator {
    private String charset;
    private String resource;
    private BufferedReader reader;
    private boolean inited;
    private boolean EOF = false;

    public FileResourceDict(String charset, String resource) {
        this.charset = charset;
        this.resource = resource;
    }

    @Override
    public DictWord next() {
        if (!this.inited) {
            InputStream in = FileResourceDict.class.getClassLoader().getResourceAsStream(this.resource);
            if (in != null) {
                this.reader = new BufferedReader(new InputStreamReader(in, Charset.forName(this.charset)));
            }
            this.inited = true;
        }
        if (this.reader == null) {
            return null;
        }
        if (this.EOF) {
            return null;
        }
        String line = null;
        try {
            line = this.reader.readLine();
        }
        catch (IOException e) {
            this.EOF = true;
            return null;
        }
        if (line == null) {
            this.EOF = true;
            return null;
        }
        DictWord word = new DictWord();
        word.setWord(line);
        return word;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Reader)this.reader);
    }
}

