/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class DaliyFixTimeRunThread
extends Thread {
    private static Logger logger = Logger.getLogger(DaliyFixTimeRunThread.class);
    private static final int MS_OF_DAY = 86400000;
    private Date runTime;
    private Runnable runnable;
    private volatile boolean onlyRunOnce;

    public DaliyFixTimeRunThread(String runTime, String threadName) {
        super(threadName);
        this.runTime = this.getTimeByExp(runTime);
    }

    public DaliyFixTimeRunThread(String runTime, Runnable runnable) {
        this.runTime = this.getTimeByExp(runTime);
        this.runnable = runnable;
    }

    private Date getTimeByExp(String time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (time == null) {
            time = sdf.format(new Date());
        }
        Date ret = null;
        try {
            ret = sdf.parse(time);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (ret == null) {
            sdf = new SimpleDateFormat("HH:mm:ss");
            try {
                ret = sdf.parse(time);
            }
            catch (ParseException e) {
                ret = new Date();
            }
        }
        return ret;
    }

    @Override
    public final void run() {
        do {
            try {
                this.sleepToRun();
            }
            catch (InterruptedException e) {
                return;
            }
            if (this.runnable != null) {
                this.runnable.run();
            }
            this.doRun();
        } while (!this.onlyRunOnce);
    }

    private synchronized void sleepToRun() throws InterruptedException {
        try {
            Date now = new Date();
            while (this.runTime.getTime() < now.getTime()) {
                this.runTime.setTime(this.runTime.getTime() + 86400000L);
            }
            long timeToSpleep = this.runTime.getTime() - now.getTime();
            logger.debug((Object)("Sleep " + timeToSpleep + " ms to run"));
            Thread.sleep(timeToSpleep);
            this.runTime.setTime(this.runTime.getTime() + 86400000L);
        }
        catch (InterruptedException e) {
            logger.error((Object)"sleep interrupted", (Throwable)e);
            throw e;
        }
    }

    protected void doRun() {
    }

    public void setOnlyRunOnce(boolean onlyRunOnce) {
        this.onlyRunOnce = onlyRunOnce;
    }

    public static void main(String[] args) {
        new DaliyFixTimeRunThread("", "");
    }
}

