package cn.pconline.search.common.taglib;

import java.io.IOException;
import java.io.Reader;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;

public class IfOutTag extends BaseTag
{

    public static final int HIGHEST_SPECIAL = '>';

    public static char[][] specialCharactersRepresentation = new char[HIGHEST_SPECIAL + 1][];
    static
    {
        specialCharactersRepresentation['&'] = "&amp;".toCharArray();
        specialCharactersRepresentation['<'] = "&lt;".toCharArray();
        specialCharactersRepresentation['>'] = "&gt;".toCharArray();
        specialCharactersRepresentation['"'] = "&#034;".toCharArray();
        specialCharactersRepresentation['\''] = "&#039;".toCharArray();
    }

    private static final long serialVersionUID = 7148081898420021463L;

    private Object trueOut;

    private Object falseOut;

    private boolean test;

    private boolean escapeXml = true;

    @Override
    public int doStartTag() throws JspException
    {
        try
        {
            Object out = test ? trueOut : falseOut;
            if (out != null)
            {
                out(pageContext, escapeXml, out);
            }
        }
        catch (IOException e)
        {
            throw new JspException(e);
        }
        return SKIP_BODY;
    }

    public void setTrueOut(String trueOut)
    {
        this.trueOut = trueOut;
    }

    public void setFalseOut(String falseOut)
    {
        this.falseOut = falseOut;
    }

    public void setTest(boolean test)
    {
        this.test = test;
    }

    public void setEscapeXml(boolean escapeXml)
    {
        this.escapeXml = escapeXml;
    }

    public static void out(PageContext pageContext, boolean escapeXml,
            Object obj) throws IOException
    {
        JspWriter w = pageContext.getOut();
        if (!escapeXml)
        {
            // write chars as is
            if (obj instanceof Reader)
            {
                Reader reader = (Reader) obj;
                char[] buf = new char[4096];
                int count;
                while ((count = reader.read(buf, 0, 4096)) != -1)
                {
                    w.write(buf, 0, count);
                }
            }
            else
            {
                w.write(obj.toString());
            }
        }
        else
        {
            // escape XML chars
            if (obj instanceof Reader)
            {
                Reader reader = (Reader) obj;
                char[] buf = new char[4096];
                int count;
                while ((count = reader.read(buf, 0, 4096)) != -1)
                {
                    writeEscapedXml(buf, count, w);
                }
            }
            else
            {
                String text = obj.toString();
                writeEscapedXml(text.toCharArray(), text.length(), w);
            }
        }
    }

    /**
     * 
     * Optimized to create no extra objects and write directly to the JspWriter
     * using blocks of escaped and unescaped characters
     * 
     */
    private static void writeEscapedXml(char[] buffer, int length, JspWriter w)
            throws IOException
    {
        int start = 0;

        for (int i = 0; i < length; i++)
        {
            char c = buffer[i];
            if (c <= HIGHEST_SPECIAL)
            {
                char[] escaped = specialCharactersRepresentation[c];
                if (escaped != null)
                {
                    // add unescaped portion
                    if (start < i)
                    {
                        w.write(buffer, start, i - start);
                    }
                    // add escaped xml
                    w.write(escaped);
                    start = i + 1;
                }
            }
        }
        // add rest of unescaped portion
        if (start < length)
        {
            w.write(buffer, start, length - start);
        }
    }

}
