package cn.pconline.search.common.tools.semantic2;

import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

import org.apache.commons.lang.StringUtils;

/**
 * 抽象分析器
 * 
 * @author zengjie
 * @since 2013-9-17
 * @see
 */
public abstract class AbstractAnalyzer implements SemanticAnalyzer
{

    private int maxWord = 0;

    private int minWord = Integer.MAX_VALUE;

    private Map<String, SemanticWord> wordMap = new HashMap<String, SemanticWord>();

    @Override
    public void loadDict(DictWordIterator dict)
    {
        DictWord word = null;
        while ((word = dict.next()) != null)
        {
            maxWord = Math.max(maxWord, word.getWord().length());
            minWord = Math.min(minWord, word.getWord().length());
            loadWordIntoMap(word, wordMap);
        }
        dict.close();
    }

    /**
     * 加载单个词条
     * 
     * @param word
     */
    protected abstract void loadWordIntoMap(DictWord word,
            Map<String, SemanticWord> wordMap);

    @Override
    public SemanticResult analyze(String input)
    {
        if (wordMap.isEmpty())
        {
            return null;
        }
        if (StringUtils.isBlank(input))
        {
            return null;
        }
        input = input.trim();
        if (input.length() < minWord)
        {
            return null;
        }
        Map<String, SemanticWord> retMap = new LinkedHashMap<String, SemanticWord>();
        char[] temp = new char[maxWord];
        String[] sequences = input.split("\\s+");
        StringBuilder otherQuery = new StringBuilder();
        for (String sequence : sequences)
        {
            if (sequence.length() < minWord)
            {
                continue;
            }
            CharBuffer buffer = CharBuffer.wrap(sequence.toCharArray());
            buffer.position(0).limit(buffer.capacity());

            while (buffer.hasRemaining())
            {
                int toGet = Math.min(temp.length, buffer.remaining());
                buffer.get(temp, 0, toGet);
                int flag = toGet;
                boolean find = false;
                while (flag >= minWord)
                {
                    String key = new String(temp, 0, flag);
                    SemanticWord word = wordMap.get(key);
                    if (word != null)
                    {
                        if (retMap.containsKey(key))
                        {
                            SemanticWord retW = retMap.get(key);
                            retW.setBoost(retW.getBoost() + word.getBoost());
                        }
                        else
                        {
                            retMap.put(key, word.getCopy());
                        }
                        buffer.position(buffer.position() - (toGet - flag));
                        otherQuery.append(" ");
                        toGet = flag;
                        find = true;
                    }
                    flag--;
                }
                if (!find)
                {
                    buffer.position(buffer.position() - toGet);
                    otherQuery.append(buffer.get());
                }
            }
            otherQuery.append(" ");
        }
        return new SemanticResult(new ArrayList<SemanticWord>(retMap.values()),
                otherQuery.toString());
    }

}
