/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.tools.segment.bean;

import cn.pconline.search.common.tools.segment.bean.TagContext;
import cn.pconline.search.common.tools.segment.utility.GFCommon;
import cn.pconline.search.common.tools.segment.utility.Utility;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;

public class ContextStat {
    private int tableLen;
    private int[] symbolTable;
    private ArrayList<TagContext> tcList = new ArrayList();

    public boolean load(String fileName) {
        return this.load(fileName, false);
    }

    public boolean load(String fileName, boolean isReset) {
        File file = new File(fileName);
        if (!file.canRead()) {
            return false;
        }
        try {
            byte[] b = null;
            DataInputStream in = new DataInputStream(new FileInputStream(file));
            this.tableLen = GFCommon.bytes2int(Utility.readBytes(in, 4), false);
            this.symbolTable = new int[this.tableLen];
            int i = 0;
            while (i < this.tableLen) {
                b = Utility.readBytes(in, 4);
                this.symbolTable[i] = GFCommon.bytes2int(b, false);
                ++i;
            }
            long fileLen = file.length();
            long curLen = 4 + this.tableLen * 4;
            while (curLen < fileLen) {
                TagContext tc = new TagContext();
                b = Utility.readBytes(in, 4);
                int key = GFCommon.bytes2int(b);
                curLen += 4L;
                b = Utility.readBytes(in, 4);
                curLen += 4L;
                int totalFreq = GFCommon.bytes2int(b, false);
                int[] tagFreq = new int[this.tableLen];
                int i2 = 0;
                while (i2 < this.tableLen) {
                    b = Utility.readBytes(in, 4);
                    curLen += 4L;
                    tagFreq[i2] = GFCommon.bytes2int(b, false);
                    ++i2;
                }
                int[][] contextArray = new int[this.tableLen][this.tableLen];
                int i3 = 0;
                while (i3 < this.tableLen) {
                    String pr = "";
                    int j = 0;
                    while (j < this.tableLen) {
                        b = Utility.readBytes(in, 4);
                        curLen += 4L;
                        contextArray[i3][j] = GFCommon.bytes2int(b, false);
                        pr = String.valueOf(pr) + " " + contextArray[i3][j];
                        ++j;
                    }
                    ++i3;
                }
                tc.setTotalFreq(totalFreq);
                tc.setKey(key);
                tc.setTagFreq(tagFreq);
                tc.setContextArray(contextArray);
                this.tcList.add(tc);
            }
            in.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public int getFreq(int key, int symbol) {
        TagContext tc = this.getItem(key);
        if (tc == null) {
            return 0;
        }
        int index = Utility.binarySearch(symbol, this.symbolTable);
        if (index == -1) {
            return 0;
        }
        int frequency = 0;
        if (tc.getTagFreq() != null) {
            frequency = tc.getTagFreq()[index];
        }
        return frequency;
    }

    public double getPossibility(int key, int prev, int cur) {
        double result = 0.0;
        int curIndex = Utility.binarySearch(cur, this.symbolTable);
        int prevIndex = Utility.binarySearch(prev, this.symbolTable);
        TagContext tc = this.getItem(key);
        if (tc == null || curIndex == -1 || prevIndex == -1 || tc.getContextArray()[prevIndex][curIndex] == 0 || tc.getTagFreq()[prevIndex] == 0) {
            return 1.0E-6;
        }
        int prevCurConFreq = tc.getContextArray()[prevIndex][curIndex];
        int prevFreq = tc.getTagFreq()[prevIndex];
        result = 0.9 * (double)prevCurConFreq;
        result /= (double)prevFreq;
        return result += 0.1 * (double)prevFreq / (double)tc.getTotalFreq();
    }

    public TagContext getItem(int key) {
        TagContext result = null;
        if (this.tcList == null || this.tcList.size() == 0) {
            return null;
        }
        if (key == 0) {
            result = this.tcList.get(0);
        } else {
            int i = 0;
            while (i < this.tcList.size() && this.tcList.get(i).getKey() < key) {
                ++i;
            }
            if (i < this.tcList.size() && this.tcList.get(i).getKey() == key) {
                result = this.tcList.get(i);
            } else if (i - 1 < this.tcList.size()) {
                result = this.tcList.get(i - 1);
            }
        }
        return result;
    }
}

