/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.tools.segment.bean;

import cn.pconline.search.common.tools.segment.bean.WordItem;
import cn.pconline.search.common.tools.segment.utility.GFCommon;
import cn.pconline.search.common.tools.segment.utility.GFString;
import cn.pconline.search.common.tools.segment.utility.Utility;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Dictionary {
    private Map<String, ArrayList<WordItem>> map = new HashMap<String, ArrayList<WordItem>>();
    private ArrayList<WordItem> emptyList = new ArrayList();

    public Dictionary() {
    }

    public Dictionary(String filename) throws IOException {
        this.load(filename);
    }

    public void load(String filename) throws IOException {
        this.load(filename, false);
    }

    public void load(String filename, boolean isReset) throws IOException {
        int[] nBuffer = new int[3];
        File file = new File(filename);
        DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        int i = 0;
        while (i < 6768) {
            int count = GFCommon.bytes2int(Utility.readBytes(in, 4), false);
            if (count > 0) {
                int j = 0;
                while (j < count) {
                    ArrayList<WordItem> l;
                    nBuffer[0] = GFCommon.bytes2int(Utility.readBytes(in, 4), false);
                    nBuffer[1] = GFCommon.bytes2int(Utility.readBytes(in, 4), false);
                    nBuffer[2] = GFCommon.bytes2int(Utility.readBytes(in, 4), false);
                    WordItem ti = new WordItem();
                    if (nBuffer[1] > 0) {
                        byte[] word = Utility.readBytes(in, nBuffer[1]);
                        ti.setWord(new String(word, "GBK"));
                    } else {
                        ti.setWord("");
                    }
                    if (isReset) {
                        ti.setFreq(0);
                    } else {
                        ti.setFreq(nBuffer[0]);
                    }
                    ti.setLen(nBuffer[1] / 2);
                    ti.setHandle(nBuffer[2]);
                    String str = ti.getWord();
                    if (i != 3755) {
                        String c = Utility.getGB(i);
                        str = String.valueOf(c) + str;
                    }
                    if ((l = this.map.get(str)) == null || this.emptyList == l) {
                        l = new ArrayList();
                        this.map.put(str, l);
                    }
                    l.add(ti);
                    String[] ss = str.split("");
                    String s = "";
                    String[] stringArray = ss;
                    int n = ss.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s1 = stringArray[n2];
                        if (s1.length() > 0 && this.map.get(s = String.valueOf(s) + s1) == null) {
                            this.map.put(s, this.emptyList);
                        }
                        ++n2;
                    }
                    ++j;
                }
            }
            ++i;
        }
        in.close();
    }

    public boolean isExist(String word, int handle) {
        ArrayList<WordItem> l;
        if (word != null && (l = this.getHandle(word)) != null) {
            for (WordItem wi : l) {
                if (wi.getHandle() != handle) continue;
                return true;
            }
        }
        return false;
    }

    public ArrayList<WordItem> getHandle(String word) {
        if (word != null) {
            return this.map.get(word);
        }
        return null;
    }

    public boolean strEqual(String b1, String b2) {
        if (b1 == null && b2 == null) {
            return true;
        }
        if (b1 != null && b2 != null) {
            return b1.equals(b2);
        }
        return false;
    }

    public int getWordType(String word) {
        if (word != null) {
            int type = Utility.charType(word);
            int len = word.length();
            if (len > 0 && type == 7 && GFString.isAllChinese(word)) {
                return 1;
            }
            if (len > 0 && type == 6) {
                return 0;
            }
        }
        return 2;
    }

    public int getFreq(String word, int handle) {
        ArrayList<WordItem> l;
        if (word != null && word.length() > 0 && (l = this.getHandle(word)) != null) {
            for (WordItem wi : l) {
                if (wi.getHandle() != handle) continue;
                return wi.getFreq();
            }
        }
        return 0;
    }
}

