/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.tools.segment.bean;

import cn.pconline.search.common.tools.segment.bean.POS;
import cn.pconline.search.common.tools.segment.utility.Utility;
import java.util.ArrayList;

public class SegNode
implements Cloneable {
    private int col;
    private int row;
    private double value;
    private int pos;
    private ArrayList<POS> allPos;
    private String word;
    private String srcWord;

    public SegNode() {
    }

    public SegNode(int row, int col, int pos, double value, String word) {
        this.row = row;
        this.col = col;
        this.pos = pos;
        this.value = value;
        this.setWord(word);
    }

    public int getCol() {
        return this.col;
    }

    public void setCol(int col) {
        this.col = col;
    }

    public int getLen() {
        return this.srcWord != null ? this.srcWord.getBytes().length : -1;
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    public void addPos(POS pos) {
        if (this.allPos == null) {
            this.allPos = new ArrayList();
        }
        this.allPos.add(pos);
    }

    public ArrayList<POS> getAllPos() {
        return this.allPos;
    }

    public void setAllPos(ArrayList<POS> posList) {
        this.allPos = posList;
    }

    public int getPosSize() {
        return this.allPos != null ? this.allPos.size() : -1;
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public String getWord() {
        return this.word;
    }

    public void appendWord(String word) {
        this.word = this.word == null ? word : String.valueOf(this.word) + word;
        this.setWord(word);
    }

    public void setWord(String word) {
        this.word = word;
        if (this.srcWord == null || !Utility.isUnknownWord(word)) {
            this.srcWord = word;
        }
    }

    public String getSrcWord() {
        return this.srcWord;
    }

    public void setSrcWord(String srcWord) {
        this.srcWord = srcWord;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public SegNode clone() {
        SegNode result = null;
        try {
            result = (SegNode)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return result;
    }
}

