/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.util;

import cn.pconline.search.common.util.Big5Util;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import org.apache.log4j.Logger;

public class CNToSpell {
    private static final Logger logger = Logger.getLogger(CNToSpell.class);
    private static LinkedHashMap<String, Integer> spellMap = null;

    static {
        if (spellMap == null) {
            spellMap = new LinkedHashMap(400);
        }
        CNToSpell.initialize();
    }

    private CNToSpell() {
    }

    private static void spellPut(String spell, int ascii) {
        spellMap.put(spell, new Integer(ascii));
    }

    private static void initialize() {
        CNToSpell.spellPut("a", -20319);
        CNToSpell.spellPut("ai", -20317);
        CNToSpell.spellPut("an", -20304);
        CNToSpell.spellPut("ang", -20295);
        CNToSpell.spellPut("ao", -20292);
        CNToSpell.spellPut("ba", -20283);
        CNToSpell.spellPut("bai", -20265);
        CNToSpell.spellPut("ban", -20257);
        CNToSpell.spellPut("bang", -20242);
        CNToSpell.spellPut("bao", -20230);
        CNToSpell.spellPut("bei", -20051);
        CNToSpell.spellPut("ben", -20036);
        CNToSpell.spellPut("beng", -20032);
        CNToSpell.spellPut("bi", -20026);
        CNToSpell.spellPut("bian", -20002);
        CNToSpell.spellPut("biao", -19990);
        CNToSpell.spellPut("bie", -19986);
        CNToSpell.spellPut("bin", -19982);
        CNToSpell.spellPut("bing", -19976);
        CNToSpell.spellPut("bo", -19805);
        CNToSpell.spellPut("bu", -19784);
        CNToSpell.spellPut("ca", -19775);
        CNToSpell.spellPut("cai", -19774);
        CNToSpell.spellPut("can", -19763);
        CNToSpell.spellPut("cang", -19756);
        CNToSpell.spellPut("cao", -19751);
        CNToSpell.spellPut("ce", -19746);
        CNToSpell.spellPut("ceng", -19741);
        CNToSpell.spellPut("cha", -19739);
        CNToSpell.spellPut("chai", -19728);
        CNToSpell.spellPut("chan", -19725);
        CNToSpell.spellPut("chang", -19715);
        CNToSpell.spellPut("chao", -19540);
        CNToSpell.spellPut("che", -19531);
        CNToSpell.spellPut("chen", -19525);
        CNToSpell.spellPut("cheng", -19515);
        CNToSpell.spellPut("chi", -19500);
        CNToSpell.spellPut("chong", -19484);
        CNToSpell.spellPut("chou", -19479);
        CNToSpell.spellPut("chu", -19467);
        CNToSpell.spellPut("chuai", -19289);
        CNToSpell.spellPut("chuan", -19288);
        CNToSpell.spellPut("chuang", -19281);
        CNToSpell.spellPut("chui", -19275);
        CNToSpell.spellPut("chun", -19270);
        CNToSpell.spellPut("chuo", -19263);
        CNToSpell.spellPut("ci", -19261);
        CNToSpell.spellPut("cong", -19249);
        CNToSpell.spellPut("cou", -19243);
        CNToSpell.spellPut("cu", -19242);
        CNToSpell.spellPut("cuan", -19238);
        CNToSpell.spellPut("cui", -19235);
        CNToSpell.spellPut("cun", -19227);
        CNToSpell.spellPut("cuo", -19224);
        CNToSpell.spellPut("da", -19218);
        CNToSpell.spellPut("dai", -19212);
        CNToSpell.spellPut("dan", -19038);
        CNToSpell.spellPut("dang", -19023);
        CNToSpell.spellPut("dao", -19018);
        CNToSpell.spellPut("de", -19006);
        CNToSpell.spellPut("deng", -19003);
        CNToSpell.spellPut("di", -18996);
        CNToSpell.spellPut("dian", -18977);
        CNToSpell.spellPut("diao", -18961);
        CNToSpell.spellPut("die", -18952);
        CNToSpell.spellPut("ding", -18783);
        CNToSpell.spellPut("diu", -18774);
        CNToSpell.spellPut("dong", -18773);
        CNToSpell.spellPut("dou", -18763);
        CNToSpell.spellPut("du", -18756);
        CNToSpell.spellPut("duan", -18741);
        CNToSpell.spellPut("dui", -18735);
        CNToSpell.spellPut("dun", -18731);
        CNToSpell.spellPut("duo", -18722);
        CNToSpell.spellPut("e", -18710);
        CNToSpell.spellPut("en", -18697);
        CNToSpell.spellPut("er", -18696);
        CNToSpell.spellPut("fa", -18526);
        CNToSpell.spellPut("fan", -18518);
        CNToSpell.spellPut("fang", -18501);
        CNToSpell.spellPut("fei", -18490);
        CNToSpell.spellPut("fen", -18478);
        CNToSpell.spellPut("feng", -18463);
        CNToSpell.spellPut("fo", -18448);
        CNToSpell.spellPut("fou", -18447);
        CNToSpell.spellPut("fu", -18446);
        CNToSpell.spellPut("ga", -18239);
        CNToSpell.spellPut("gai", -18237);
        CNToSpell.spellPut("gan", -18231);
        CNToSpell.spellPut("gang", -18220);
        CNToSpell.spellPut("gao", -18211);
        CNToSpell.spellPut("ge", -18201);
        CNToSpell.spellPut("gei", -18184);
        CNToSpell.spellPut("gen", -18183);
        CNToSpell.spellPut("geng", -18181);
        CNToSpell.spellPut("gong", -18012);
        CNToSpell.spellPut("gou", -17997);
        CNToSpell.spellPut("gu", -17988);
        CNToSpell.spellPut("gua", -17970);
        CNToSpell.spellPut("guai", -17964);
        CNToSpell.spellPut("guan", -17961);
        CNToSpell.spellPut("guang", -17950);
        CNToSpell.spellPut("gui", -17947);
        CNToSpell.spellPut("gun", -17931);
        CNToSpell.spellPut("guo", -17928);
        CNToSpell.spellPut("ha", -17922);
        CNToSpell.spellPut("hai", -17759);
        CNToSpell.spellPut("han", -17752);
        CNToSpell.spellPut("hang", -17733);
        CNToSpell.spellPut("hao", -17730);
        CNToSpell.spellPut("he", -17721);
        CNToSpell.spellPut("hei", -17703);
        CNToSpell.spellPut("hen", -17701);
        CNToSpell.spellPut("heng", -17697);
        CNToSpell.spellPut("hong", -17692);
        CNToSpell.spellPut("hou", -17683);
        CNToSpell.spellPut("hu", -17676);
        CNToSpell.spellPut("hua", -17496);
        CNToSpell.spellPut("huai", -17487);
        CNToSpell.spellPut("huan", -17482);
        CNToSpell.spellPut("huang", -17468);
        CNToSpell.spellPut("hui", -17454);
        CNToSpell.spellPut("hun", -17433);
        CNToSpell.spellPut("huo", -17427);
        CNToSpell.spellPut("ji", -17417);
        CNToSpell.spellPut("jia", -17202);
        CNToSpell.spellPut("jian", -17185);
        CNToSpell.spellPut("jiang", -16983);
        CNToSpell.spellPut("jiao", -16970);
        CNToSpell.spellPut("jie", -16942);
        CNToSpell.spellPut("jin", -16915);
        CNToSpell.spellPut("jing", -16733);
        CNToSpell.spellPut("jiong", -16708);
        CNToSpell.spellPut("jiu", -16706);
        CNToSpell.spellPut("ju", -16689);
        CNToSpell.spellPut("juan", -16664);
        CNToSpell.spellPut("jue", -16657);
        CNToSpell.spellPut("jun", -16647);
        CNToSpell.spellPut("ka", -16474);
        CNToSpell.spellPut("kai", -16470);
        CNToSpell.spellPut("kan", -16465);
        CNToSpell.spellPut("kang", -16459);
        CNToSpell.spellPut("kao", -16452);
        CNToSpell.spellPut("ke", -16448);
        CNToSpell.spellPut("ken", -16433);
        CNToSpell.spellPut("keng", -16429);
        CNToSpell.spellPut("kong", -16427);
        CNToSpell.spellPut("kou", -16423);
        CNToSpell.spellPut("ku", -16419);
        CNToSpell.spellPut("kua", -16412);
        CNToSpell.spellPut("kuai", -16407);
        CNToSpell.spellPut("kuan", -16403);
        CNToSpell.spellPut("kuang", -16401);
        CNToSpell.spellPut("kui", -16393);
        CNToSpell.spellPut("kun", -16220);
        CNToSpell.spellPut("kuo", -16216);
        CNToSpell.spellPut("la", -16212);
        CNToSpell.spellPut("lai", -16205);
        CNToSpell.spellPut("lan", -16202);
        CNToSpell.spellPut("lang", -16187);
        CNToSpell.spellPut("lao", -16180);
        CNToSpell.spellPut("le", -16171);
        CNToSpell.spellPut("lei", -16169);
        CNToSpell.spellPut("leng", -16158);
        CNToSpell.spellPut("li", -16155);
        CNToSpell.spellPut("lia", -15959);
        CNToSpell.spellPut("lian", -15958);
        CNToSpell.spellPut("liang", -15944);
        CNToSpell.spellPut("liao", -15933);
        CNToSpell.spellPut("lie", -15920);
        CNToSpell.spellPut("lin", -15915);
        CNToSpell.spellPut("ling", -15903);
        CNToSpell.spellPut("liu", -15889);
        CNToSpell.spellPut("long", -15878);
        CNToSpell.spellPut("lou", -15707);
        CNToSpell.spellPut("lu", -15701);
        CNToSpell.spellPut("lv", -15681);
        CNToSpell.spellPut("luan", -15667);
        CNToSpell.spellPut("lue", -15661);
        CNToSpell.spellPut("lun", -15659);
        CNToSpell.spellPut("luo", -15652);
        CNToSpell.spellPut("ma", -15640);
        CNToSpell.spellPut("mai", -15631);
        CNToSpell.spellPut("man", -15625);
        CNToSpell.spellPut("mang", -15454);
        CNToSpell.spellPut("mao", -15448);
        CNToSpell.spellPut("me", -15436);
        CNToSpell.spellPut("mei", -15435);
        CNToSpell.spellPut("men", -15419);
        CNToSpell.spellPut("meng", -15416);
        CNToSpell.spellPut("mi", -15408);
        CNToSpell.spellPut("mian", -15394);
        CNToSpell.spellPut("miao", -15385);
        CNToSpell.spellPut("mie", -15377);
        CNToSpell.spellPut("min", -15375);
        CNToSpell.spellPut("ming", -15369);
        CNToSpell.spellPut("miu", -15363);
        CNToSpell.spellPut("mo", -15362);
        CNToSpell.spellPut("mou", -15183);
        CNToSpell.spellPut("mu", -15180);
        CNToSpell.spellPut("na", -15165);
        CNToSpell.spellPut("nai", -15158);
        CNToSpell.spellPut("nan", -15153);
        CNToSpell.spellPut("nang", -15150);
        CNToSpell.spellPut("nao", -15149);
        CNToSpell.spellPut("ne", -15144);
        CNToSpell.spellPut("nei", -15143);
        CNToSpell.spellPut("nen", -15141);
        CNToSpell.spellPut("neng", -15140);
        CNToSpell.spellPut("ni", -15139);
        CNToSpell.spellPut("nian", -15128);
        CNToSpell.spellPut("niang", -15121);
        CNToSpell.spellPut("niao", -15119);
        CNToSpell.spellPut("nie", -15117);
        CNToSpell.spellPut("nin", -15110);
        CNToSpell.spellPut("ning", -15109);
        CNToSpell.spellPut("niu", -14941);
        CNToSpell.spellPut("nong", -14937);
        CNToSpell.spellPut("nu", -14933);
        CNToSpell.spellPut("nv", -14930);
        CNToSpell.spellPut("nuan", -14929);
        CNToSpell.spellPut("nue", -14928);
        CNToSpell.spellPut("nuo", -14926);
        CNToSpell.spellPut("o", -14922);
        CNToSpell.spellPut("ou", -14921);
        CNToSpell.spellPut("pa", -14914);
        CNToSpell.spellPut("pai", -14908);
        CNToSpell.spellPut("pan", -14902);
        CNToSpell.spellPut("pang", -14894);
        CNToSpell.spellPut("pao", -14889);
        CNToSpell.spellPut("pei", -14882);
        CNToSpell.spellPut("pen", -14873);
        CNToSpell.spellPut("peng", -14871);
        CNToSpell.spellPut("pi", -14857);
        CNToSpell.spellPut("pian", -14678);
        CNToSpell.spellPut("piao", -14674);
        CNToSpell.spellPut("pie", -14670);
        CNToSpell.spellPut("pin", -14668);
        CNToSpell.spellPut("ping", -14663);
        CNToSpell.spellPut("po", -14654);
        CNToSpell.spellPut("pu", -14645);
        CNToSpell.spellPut("qi", -14630);
        CNToSpell.spellPut("qia", -14594);
        CNToSpell.spellPut("qian", -14429);
        CNToSpell.spellPut("qiang", -14407);
        CNToSpell.spellPut("qiao", -14399);
        CNToSpell.spellPut("qie", -14384);
        CNToSpell.spellPut("qin", -14379);
        CNToSpell.spellPut("qing", -14368);
        CNToSpell.spellPut("qiong", -14355);
        CNToSpell.spellPut("qiu", -14353);
        CNToSpell.spellPut("qu", -14345);
        CNToSpell.spellPut("quan", -14170);
        CNToSpell.spellPut("que", -14159);
        CNToSpell.spellPut("qun", -14151);
        CNToSpell.spellPut("ran", -14149);
        CNToSpell.spellPut("rang", -14145);
        CNToSpell.spellPut("rao", -14140);
        CNToSpell.spellPut("re", -14137);
        CNToSpell.spellPut("ren", -14135);
        CNToSpell.spellPut("reng", -14125);
        CNToSpell.spellPut("ri", -14123);
        CNToSpell.spellPut("rong", -14122);
        CNToSpell.spellPut("rou", -14112);
        CNToSpell.spellPut("ru", -14109);
        CNToSpell.spellPut("ruan", -14099);
        CNToSpell.spellPut("rui", -14097);
        CNToSpell.spellPut("run", -14094);
        CNToSpell.spellPut("ruo", -14092);
        CNToSpell.spellPut("sa", -14090);
        CNToSpell.spellPut("sai", -14087);
        CNToSpell.spellPut("san", -14083);
        CNToSpell.spellPut("sang", -13917);
        CNToSpell.spellPut("sao", -13914);
        CNToSpell.spellPut("se", -13910);
        CNToSpell.spellPut("sen", -13907);
        CNToSpell.spellPut("seng", -13906);
        CNToSpell.spellPut("sha", -13905);
        CNToSpell.spellPut("shai", -13896);
        CNToSpell.spellPut("shan", -13894);
        CNToSpell.spellPut("shang", -13878);
        CNToSpell.spellPut("shao", -13870);
        CNToSpell.spellPut("she", -13859);
        CNToSpell.spellPut("shen", -13847);
        CNToSpell.spellPut("sheng", -13831);
        CNToSpell.spellPut("shi", -13658);
        CNToSpell.spellPut("shou", -13611);
        CNToSpell.spellPut("shu", -13601);
        CNToSpell.spellPut("shua", -13406);
        CNToSpell.spellPut("shuai", -13404);
        CNToSpell.spellPut("shuan", -13400);
        CNToSpell.spellPut("shuang", -13398);
        CNToSpell.spellPut("shui", -13395);
        CNToSpell.spellPut("shun", -13391);
        CNToSpell.spellPut("shuo", -13387);
        CNToSpell.spellPut("si", -13383);
        CNToSpell.spellPut("song", -13367);
        CNToSpell.spellPut("sou", -13359);
        CNToSpell.spellPut("su", -13356);
        CNToSpell.spellPut("suan", -13343);
        CNToSpell.spellPut("sui", -13340);
        CNToSpell.spellPut("sun", -13329);
        CNToSpell.spellPut("suo", -13326);
        CNToSpell.spellPut("ta", -13318);
        CNToSpell.spellPut("tai", -13147);
        CNToSpell.spellPut("tan", -13138);
        CNToSpell.spellPut("tang", -13120);
        CNToSpell.spellPut("tao", -13107);
        CNToSpell.spellPut("te", -13096);
        CNToSpell.spellPut("teng", -13095);
        CNToSpell.spellPut("ti", -13091);
        CNToSpell.spellPut("tian", -13076);
        CNToSpell.spellPut("tiao", -13068);
        CNToSpell.spellPut("tie", -13063);
        CNToSpell.spellPut("ting", -13060);
        CNToSpell.spellPut("tong", -12888);
        CNToSpell.spellPut("tou", -12875);
        CNToSpell.spellPut("tu", -12871);
        CNToSpell.spellPut("tuan", -12860);
        CNToSpell.spellPut("tui", -12858);
        CNToSpell.spellPut("tun", -12852);
        CNToSpell.spellPut("tuo", -12849);
        CNToSpell.spellPut("wa", -12838);
        CNToSpell.spellPut("wai", -12831);
        CNToSpell.spellPut("wan", -12829);
        CNToSpell.spellPut("wang", -12812);
        CNToSpell.spellPut("wei", -12802);
        CNToSpell.spellPut("wen", -12607);
        CNToSpell.spellPut("weng", -12597);
        CNToSpell.spellPut("wo", -12594);
        CNToSpell.spellPut("wu", -12585);
        CNToSpell.spellPut("xi", -12556);
        CNToSpell.spellPut("xia", -12359);
        CNToSpell.spellPut("xian", -12346);
        CNToSpell.spellPut("xiang", -12320);
        CNToSpell.spellPut("xiao", -12300);
        CNToSpell.spellPut("xie", -12120);
        CNToSpell.spellPut("xin", -12099);
        CNToSpell.spellPut("xing", -12089);
        CNToSpell.spellPut("xiong", -12074);
        CNToSpell.spellPut("xiu", -12067);
        CNToSpell.spellPut("xu", -12058);
        CNToSpell.spellPut("xuan", -12039);
        CNToSpell.spellPut("xue", -11867);
        CNToSpell.spellPut("xun", -11861);
        CNToSpell.spellPut("ya", -11847);
        CNToSpell.spellPut("yan", -11831);
        CNToSpell.spellPut("yang", -11798);
        CNToSpell.spellPut("yao", -11781);
        CNToSpell.spellPut("ye", -11604);
        CNToSpell.spellPut("yi", -11589);
        CNToSpell.spellPut("yin", -11536);
        CNToSpell.spellPut("ying", -11358);
        CNToSpell.spellPut("yo", -11340);
        CNToSpell.spellPut("yong", -11339);
        CNToSpell.spellPut("you", -11324);
        CNToSpell.spellPut("yu", -11303);
        CNToSpell.spellPut("yuan", -11097);
        CNToSpell.spellPut("yue", -11077);
        CNToSpell.spellPut("yun", -11067);
        CNToSpell.spellPut("za", -11055);
        CNToSpell.spellPut("zai", -11052);
        CNToSpell.spellPut("zan", -11045);
        CNToSpell.spellPut("zang", -11041);
        CNToSpell.spellPut("zao", -11038);
        CNToSpell.spellPut("ze", -11024);
        CNToSpell.spellPut("zei", -11020);
        CNToSpell.spellPut("zen", -11019);
        CNToSpell.spellPut("zeng", -11018);
        CNToSpell.spellPut("zha", -11014);
        CNToSpell.spellPut("zhai", -10838);
        CNToSpell.spellPut("zhan", -10832);
        CNToSpell.spellPut("zhang", -10815);
        CNToSpell.spellPut("zhao", -10800);
        CNToSpell.spellPut("zhe", -10790);
        CNToSpell.spellPut("zhen", -10780);
        CNToSpell.spellPut("zheng", -10764);
        CNToSpell.spellPut("zhi", -10587);
        CNToSpell.spellPut("zhong", -10544);
        CNToSpell.spellPut("zhou", -10533);
        CNToSpell.spellPut("zhu", -10519);
        CNToSpell.spellPut("zhua", -10331);
        CNToSpell.spellPut("zhuai", -10329);
        CNToSpell.spellPut("zhuan", -10328);
        CNToSpell.spellPut("zhuang", -10322);
        CNToSpell.spellPut("zhui", -10315);
        CNToSpell.spellPut("zhun", -10309);
        CNToSpell.spellPut("zhuo", -10307);
        CNToSpell.spellPut("zi", -10296);
        CNToSpell.spellPut("zong", -10281);
        CNToSpell.spellPut("zou", -10274);
        CNToSpell.spellPut("zu", -10270);
        CNToSpell.spellPut("zuan", -10262);
        CNToSpell.spellPut("zui", -10260);
        CNToSpell.spellPut("zun", -10256);
        CNToSpell.spellPut("zuo", -10254);
    }

    public static int getCNAscii(char cn) {
        byte[] bytes = null;
        try {
            bytes = String.valueOf(cn).getBytes("GBK");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"gbk is not supported in current JVM", (Throwable)e);
            return 0;
        }
        if (bytes == null || bytes.length > 2 || bytes.length <= 0) {
            return 0;
        }
        if (bytes.length == 1) {
            return bytes[0];
        }
        if (bytes.length == 2) {
            int hightByte = 256 + bytes[0];
            int lowByte = 256 + bytes[1];
            int ascii = 256 * hightByte + lowByte - 65536;
            return ascii;
        }
        return 0;
    }

    public static String getSpellByAscii(int ascii) {
        if (ascii > 0 && ascii < 160) {
            return String.valueOf((char)ascii);
        }
        if (ascii < -20319 || ascii > -10247) {
            return null;
        }
        Set<String> keySet = spellMap.keySet();
        Iterator<String> it = keySet.iterator();
        String spell0 = null;
        String spell = null;
        int asciiRang0 = -20319;
        while (it.hasNext()) {
            spell = it.next();
            Integer valObj = spellMap.get(spell);
            if (!(valObj instanceof Integer)) continue;
            int asciiRang = valObj;
            if (ascii >= asciiRang0 && ascii < asciiRang) {
                return spell0 == null ? spell : spell0;
            }
            spell0 = spell;
            asciiRang0 = asciiRang;
        }
        return null;
    }

    public static String getFullSpell(String cnStr) {
        if (cnStr == null || "".equals(cnStr.trim())) {
            return cnStr;
        }
        char[] chars = cnStr.toCharArray();
        StringBuffer retuBuf = new StringBuffer();
        int i = 0;
        int Len = chars.length;
        while (i < Len) {
            int ascii = CNToSpell.getCNAscii(chars[i]);
            if (ascii == 0) {
                retuBuf.append(chars[i]);
            } else {
                String simplified;
                String spell = CNToSpell.getSpellByAscii(ascii);
                if (spell == null && (simplified = Big5Util.getSimplifiedStr(new String(new char[]{chars[i]}))) != null && (ascii = CNToSpell.getCNAscii(simplified.charAt(0))) != 0) {
                    spell = CNToSpell.getSpellByAscii(ascii);
                }
                if (spell == null) {
                    retuBuf.append(chars[i]);
                } else {
                    retuBuf.append(spell);
                }
            }
            ++i;
        }
        return retuBuf.toString();
    }

    public static void main(String[] args) {
        String str = null;
        str = "\u797a\u745e";
        System.out.println("Spell=" + CNToSpell.getFullSpell(str));
    }
}

