/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.log;

import cn.pconline.search.common.Configuration;
import cn.pconline.search.common.log.GroupCounter;
import cn.pconline.search.common.log.LogIO;
import cn.pconline.search.common.log.SearchLog;
import cn.pconline.search.common.log.SearchLogHelper;
import cn.pconline.search.common.util.DaliyFixTimeRunThread;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.jdbc.OracleDriver;
import org.apache.log4j.Logger;

public class LogSaveThread
extends DaliyFixTimeRunThread {
    private static Logger logger = Logger.getLogger(LogSaveThread.class);
    private static final int WEEK = 1;
    private static final int MONTH = 2;
    private static final int YEAR = 3;
    private static final int WEEK_MONTH = 4;
    private static final int WEEK_YEAR = 5;
    private static final int MONTH_YEAR = 6;
    private static final int WEEK_MONTH_YEAR = 7;
    private LogIO logIO;
    private Configuration config;
    private Map<SearchLog, Integer> keyOccurMap;

    public LogSaveThread(LogIO logIO, Configuration config) {
        super(config.getConfig("searchLogSaveTime"), "SearchLog_Save_Thread");
        this.logIO = logIO;
        this.config = config;
    }

    @Override
    protected void doRun() {
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        this.keyOccurMap = new HashMap<SearchLog, Integer>();
        long startTime = System.currentTimeMillis();
        Connection con = null;
        Statement sta = null;
        Statement batchSta = null;
        String adDbUrl = this.config.getConfig("ad.dburl", null);
        if (adDbUrl == null) {
            logger.info((Object)"No AD setting for application found.");
            return;
        }
        String user = this.config.getConfig("ad.user", null);
        String passwd = this.config.getConfig("ad.passwd", null);
        try {
            try {
                DriverManager.registerDriver((Driver)new OracleDriver());
                con = DriverManager.getConnection(adDbUrl, user, passwd);
                con.setAutoCommit(false);
                sta = con.createStatement();
                batchSta = con.createStatement();
                int count = this.getUpdateOrSave(sta, batchSta, Integer.MAX_VALUE, LogSaveThread.getNowTime());
                batchSta.executeBatch();
                con.commit();
                long endTime = System.currentTimeMillis();
                logger.info((Object)("\u5173\u952e\u5b57\u5165\u5e93\u5b8c\u6bd5!\u6240\u7528\u65f6\u95f4: " + (endTime - startTime) + ",\u603b\u6570\u636e\u6761\u6570:" + count));
            }
            catch (Exception e) {
                logger.error((Object)"Save search log error", (Throwable)e);
                try {
                    sta.close();
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
                try {
                    con.close();
                }
                catch (SQLException e3) {
                    e3.printStackTrace();
                }
            }
        }
        finally {
            try {
                sta.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                con.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    protected int getUpdateOrSave(Statement sta, Statement batchSta, int topNum, int time) throws Exception {
        ResultSet rs = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        boolean hasUpdate = false;
        List<GroupCounter.Item> list = SearchLogHelper.getTop(this.logIO, topNum < 0 ? Integer.MAX_VALUE : topNum, this.keyOccurMap);
        int totalCount = 0;
        int i = 0;
        int c = list.size();
        while (i < c) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            GroupCounter.Item item = list.get(i);
            int count = item.getCount();
            Integer res = this.keyOccurMap.get(item.getKey());
            String existSql = "select * from SEARCHKEYLOG sl where sl.keyword='" + item.getKey().getKey() + "' and sl.app='" + item.getKey().getApp() + "'";
            rs = sta.executeQuery(existSql);
            if (rs.next()) {
                hasUpdate = sdf.format(rs.getDate("updatetime")).equals(LogIO.getFileKey(LogIO.getYesterday()));
                String updateSql = "update KS_SEARCHKEY_LOG sl  SET sl.summary=sl.summary+" + count + "," + " sl.week_num=" + (time == 1 || time == 5 || time == 4 || time == 7 ? "" : "sl.week_num+") + count + "," + " sl.month_num=" + (time == 2 || time == 6 || time == 4 || time == 7 ? "" : "sl.month_num+") + count + "," + " sl.yesterday_num=" + (hasUpdate ? "sl.yesterday_num+" : "") + count + "," + " sl.last_search_num=" + res + "," + " sl.year_num=" + (time == 3 || time == 6 || time == 5 || time == 7 ? "" : "sl.year_num+") + count + "," + " sl.updatetime=sysdate-1" + " where sl.keyword='" + item.getKey().getKey() + "' and sl.app='" + item.getKey().getApp() + "'";
                hasUpdate = false;
                batchSta.addBatch(updateSql);
            } else {
                String insertSql = "insert into KS_SEARCHKEY_LOG(id, keyword, app, summary, createtime, updatetime, week_num, month_num, yesterday_num, year_num, last_search_num) values(SEQ_SERARCHKEY_ID.nextval, '" + item.getKey().getKey() + "','" + item.getKey().getApp() + "'," + count + ",sysdate-1,sysdate-1," + count + "," + count + "," + count + "," + count + "," + res + ")";
                batchSta.addBatch(insertSql);
            }
            ++totalCount;
            ++i;
        }
        return totalCount;
    }

    private static int getNowTime() {
        boolean isYear;
        Calendar c = Calendar.getInstance();
        c.set(5, c.get(5) - 1);
        boolean isWeek = c.get(7) - 1 == 1;
        boolean isMonth = c.get(5) == c.getMinimum(5);
        boolean bl = isYear = c.get(6) == 1;
        if (isWeek && isMonth && isYear) {
            return 7;
        }
        if (isWeek && isMonth) {
            return 4;
        }
        if (isWeek && isYear) {
            return 5;
        }
        if (isMonth && isYear) {
            return 6;
        }
        if (isWeek) {
            return 1;
        }
        if (isMonth) {
            return 2;
        }
        if (isYear) {
            return 3;
        }
        return -1;
    }
}

