/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.tools.ad;

import cn.pconline.search.common.Configuration;
import cn.pconline.search.common.tools.ad.AdRecord;
import cn.pconline.search.common.util.DaliyFixTimeRunThread;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import oracle.jdbc.OracleDriver;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AdManager
extends DaliyFixTimeRunThread {
    private static Logger logger = Logger.getLogger(AdManager.class);
    private ReentrantLock loadLock = new ReentrantLock();
    private String adDBUrl;
    private volatile Map<String, Map<String, List<AdRecord>>> adMap = null;

    public AdManager(Configuration config) {
        super(config.getConfig("adReloadTime"), "Ad-Reload-Thread");
        this.adDBUrl = config.getConfig("adDBUrl");
        if (StringUtils.isEmpty((String)this.adDBUrl)) {
            throw new IllegalArgumentException("adDBUrl is empty!");
        }
        this.loadAd();
    }

    @Override
    protected void doRun() {
        this.loadAd();
    }

    public void loadAd() {
        block32: {
            this.loadLock.lock();
            Connection conn = null;
            Statement sta = null;
            ResultSet res = null;
            try {
                try {
                    DriverManager.registerDriver((Driver)new OracleDriver());
                    conn = DriverManager.getConnection(this.adDBUrl);
                    String sql = "SELECT SERVICE_ID, KEY_WORD, AD_CONTENT_ID, AD_DESC, AD_URL, weight FROM YISOU_AD WHERE START_DATE<=SYSDATE AND SYSDATE<=(END_DATE+1)";
                    AdRecord record = null;
                    sta = conn.createStatement();
                    res = sta.executeQuery(sql);
                    HashMap<String, Map<String, List<AdRecord>>> appAdMap = new HashMap<String, Map<String, List<AdRecord>>>();
                    while (res.next()) {
                        ArrayList<AdRecord> records;
                        HashMap<String, ArrayList<AdRecord>> keyRecordMap;
                        int idx;
                        record = new AdRecord();
                        record.setApp(res.getString("SERVICE_ID"));
                        record.setKey(res.getString("KEY_WORD").toUpperCase());
                        record.setMappedDocId(res.getString("AD_CONTENT_ID"));
                        record.setAdDesc(res.getString("AD_DESC"));
                        record.setTargetUrl(res.getString("AD_URL"));
                        String weight = res.getString("weight");
                        record.setWeight(Float.valueOf(weight == null ? 0.0f : Float.parseFloat(weight)));
                        int n = idx = record.getMappedDocId() == null ? -1 : record.getMappedDocId().indexOf(58);
                        if (idx >= 0) {
                            record.setMappedDocId(record.getMappedDocId().substring(idx + 1));
                        }
                        if ((keyRecordMap = (HashMap<String, ArrayList<AdRecord>>)appAdMap.get(record.getApp())) == null) {
                            keyRecordMap = new HashMap<String, ArrayList<AdRecord>>();
                            appAdMap.put(record.getApp(), keyRecordMap);
                        }
                        if ((records = (ArrayList<AdRecord>)keyRecordMap.get(record.getKey())) == null) {
                            records = new ArrayList<AdRecord>();
                            keyRecordMap.put(record.getKey(), records);
                        }
                        records.add(record);
                    }
                    AdManager.normalizeAdMap(appAdMap);
                    this.adMap = appAdMap;
                }
                catch (Exception e) {
                    logger.error((Object)"load ad info error", (Throwable)e);
                    this.loadLock.unlock();
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (sta != null) {
                        try {
                            sta.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (conn == null) break block32;
                    try {
                        conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            finally {
                this.loadLock.unlock();
                if (res != null) {
                    try {
                        res.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (sta != null) {
                    try {
                        sta.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
    }

    public List<AdRecord> getAdRecords(String app, String keyword) {
        if (StringUtils.isEmpty((String)app) || StringUtils.isBlank((String)keyword)) {
            return null;
        }
        Map<String, List<AdRecord>> map = this.adMap.get(app);
        if (map == null) {
            return null;
        }
        List<AdRecord> records = map.get(keyword);
        if (records == null) {
            return null;
        }
        return Collections.unmodifiableList(records);
    }

    private static void normalizeAdMap(Map<String, Map<String, List<AdRecord>>> adMap) {
        for (Map.Entry<String, Map<String, List<AdRecord>>> en : adMap.entrySet()) {
            Map<String, List<AdRecord>> map = en.getValue();
            for (List<AdRecord> records : map.values()) {
                Collections.sort(records, new Comparator<AdRecord>(){

                    @Override
                    public int compare(AdRecord o1, AdRecord o2) {
                        if (o1.getWeight().floatValue() > o2.getWeight().floatValue()) {
                            return 1;
                        }
                        if (o1.getWeight().floatValue() < o2.getWeight().floatValue()) {
                            return -1;
                        }
                        return 0;
                    }
                });
            }
        }
    }
}

