/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.tools.segment.utility;

import cn.pconline.search.common.tools.segment.utility.GFCommon;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class GFString {
    private static final HashMap<String, String> map_hex2bin = new HashMap(16);
    public static final HashMap<String, String> map_bin2hex = new HashMap(16);
    private static final LinkedHashMap<String, Integer> bopoMap = new LinkedHashMap();

    public GFString() {
        map_hex2bin.put("0", "0000");
        map_hex2bin.put("1", "0001");
        map_hex2bin.put("2", "0010");
        map_hex2bin.put("3", "0011");
        map_hex2bin.put("4", "0100");
        map_hex2bin.put("5", "0101");
        map_hex2bin.put("6", "0110");
        map_hex2bin.put("7", "0111");
        map_hex2bin.put("8", "1000");
        map_hex2bin.put("9", "1001");
        map_hex2bin.put("A", "1010");
        map_hex2bin.put("B", "1011");
        map_hex2bin.put("C", "1100");
        map_hex2bin.put("D", "1101");
        map_hex2bin.put("E", "1110");
        map_hex2bin.put("F", "1111");
        map_bin2hex.put("0000", "0");
        map_bin2hex.put("0001", "1");
        map_bin2hex.put("0010", "2");
        map_bin2hex.put("0011", "3");
        map_bin2hex.put("0100", "4");
        map_bin2hex.put("0101", "5");
        map_bin2hex.put("0110", "6");
        map_bin2hex.put("0111", "7");
        map_bin2hex.put("1000", "8");
        map_bin2hex.put("1001", "9");
        map_bin2hex.put("1010", "A");
        map_bin2hex.put("1011", "B");
        map_bin2hex.put("1100", "C");
        map_bin2hex.put("1101", "D");
        map_bin2hex.put("1110", "E");
        map_bin2hex.put("1111", "F");
        bopoMap.put("a", 1);
        bopoMap.put("a", -20319);
        bopoMap.put("ai", -20317);
        bopoMap.put("an", -20304);
        bopoMap.put("ang", -20295);
        bopoMap.put("ao", -20292);
        bopoMap.put("ba", -20283);
        bopoMap.put("bai", -20265);
        bopoMap.put("ban", -20257);
        bopoMap.put("bang", -20242);
        bopoMap.put("bao", -20230);
        bopoMap.put("bei", -20051);
        bopoMap.put("ben", -20036);
        bopoMap.put("beng", -20032);
        bopoMap.put("bi", -20026);
        bopoMap.put("bian", -20002);
        bopoMap.put("biao", -19990);
        bopoMap.put("bie", -19986);
        bopoMap.put("bin", -19982);
        bopoMap.put("bing", -19976);
        bopoMap.put("bo", -19805);
        bopoMap.put("bu", -19784);
        bopoMap.put("ca", -19775);
        bopoMap.put("cai", -19774);
        bopoMap.put("can", -19763);
        bopoMap.put("cang", -19756);
        bopoMap.put("cao", -19751);
        bopoMap.put("ce", -19746);
        bopoMap.put("ceng", -19741);
        bopoMap.put("cha", -19739);
        bopoMap.put("chai", -19728);
        bopoMap.put("chan", -19725);
        bopoMap.put("chang", -19715);
        bopoMap.put("chao", -19540);
        bopoMap.put("che", -19531);
        bopoMap.put("chen", -19525);
        bopoMap.put("cheng", -19515);
        bopoMap.put("chi", -19500);
        bopoMap.put("chong", -19484);
        bopoMap.put("chou", -19479);
        bopoMap.put("chu", -19467);
        bopoMap.put("chuai", -19289);
        bopoMap.put("chuan", -19288);
        bopoMap.put("chuang", -19281);
        bopoMap.put("chui", -19275);
        bopoMap.put("chun", -19270);
        bopoMap.put("chuo", -19263);
        bopoMap.put("ci", -19261);
        bopoMap.put("cong", -19249);
        bopoMap.put("cou", -19243);
        bopoMap.put("cu", -19242);
        bopoMap.put("cuan", -19238);
        bopoMap.put("cui", -19235);
        bopoMap.put("cun", -19227);
        bopoMap.put("cuo", -19224);
        bopoMap.put("da", -19218);
        bopoMap.put("dai", -19212);
        bopoMap.put("dan", -19038);
        bopoMap.put("dang", -19023);
        bopoMap.put("dao", -19018);
        bopoMap.put("de", -19006);
        bopoMap.put("deng", -19003);
        bopoMap.put("di", -18996);
        bopoMap.put("dian", -18977);
        bopoMap.put("diao", -18961);
        bopoMap.put("die", -18952);
        bopoMap.put("ding", -18783);
        bopoMap.put("diu", -18774);
        bopoMap.put("dong", -18773);
        bopoMap.put("dou", -18763);
        bopoMap.put("du", -18756);
        bopoMap.put("duan", -18741);
        bopoMap.put("dui", -18735);
        bopoMap.put("dun", -18731);
        bopoMap.put("duo", -18722);
        bopoMap.put("e", -18710);
        bopoMap.put("en", -18697);
        bopoMap.put("er", -18696);
        bopoMap.put("fa", -18526);
        bopoMap.put("fan", -18518);
        bopoMap.put("fang", -18501);
        bopoMap.put("fei", -18490);
        bopoMap.put("fen", -18478);
        bopoMap.put("feng", -18463);
        bopoMap.put("fo", -18448);
        bopoMap.put("fou", -18447);
        bopoMap.put("fu", -18446);
        bopoMap.put("ga", -18239);
        bopoMap.put("gai", -18237);
        bopoMap.put("gan", -18231);
        bopoMap.put("gang", -18220);
        bopoMap.put("gao", -18211);
        bopoMap.put("ge", -18201);
        bopoMap.put("gei", -18184);
        bopoMap.put("gen", -18183);
        bopoMap.put("geng", -18181);
        bopoMap.put("gong", -18012);
        bopoMap.put("gou", -17997);
        bopoMap.put("gu", -17988);
        bopoMap.put("gua", -17970);
        bopoMap.put("guai", -17964);
        bopoMap.put("guan", -17961);
        bopoMap.put("guang", -17950);
        bopoMap.put("gui", -17947);
        bopoMap.put("gun", -17931);
        bopoMap.put("guo", -17928);
        bopoMap.put("ha", -17922);
        bopoMap.put("hai", -17759);
        bopoMap.put("han", -17752);
        bopoMap.put("hang", -17733);
        bopoMap.put("hao", -17730);
        bopoMap.put("he", -17721);
        bopoMap.put("hei", -17703);
        bopoMap.put("hen", -17701);
        bopoMap.put("heng", -17697);
        bopoMap.put("hong", -17692);
        bopoMap.put("hou", -17683);
        bopoMap.put("hu", -17676);
        bopoMap.put("hua", -17496);
        bopoMap.put("huai", -17487);
        bopoMap.put("huan", -17482);
        bopoMap.put("huang", -17468);
        bopoMap.put("hui", -17454);
        bopoMap.put("hun", -17433);
        bopoMap.put("huo", -17427);
        bopoMap.put("ji", -17417);
        bopoMap.put("jia", -17202);
        bopoMap.put("jian", -17185);
        bopoMap.put("jiang", -16983);
        bopoMap.put("jiao", -16970);
        bopoMap.put("jie", -16942);
        bopoMap.put("jin", -16915);
        bopoMap.put("jing", -16733);
        bopoMap.put("jiong", -16708);
        bopoMap.put("jiu", -16706);
        bopoMap.put("ju", -16689);
        bopoMap.put("juan", -16664);
        bopoMap.put("jue", -16657);
        bopoMap.put("jun", -16647);
        bopoMap.put("ka", -16474);
        bopoMap.put("kai", -16470);
        bopoMap.put("kan", -16465);
        bopoMap.put("kang", -16459);
        bopoMap.put("kao", -16452);
        bopoMap.put("ke", -16448);
        bopoMap.put("ken", -16433);
        bopoMap.put("keng", -16429);
        bopoMap.put("kong", -16427);
        bopoMap.put("kou", -16423);
        bopoMap.put("ku", -16419);
        bopoMap.put("kua", -16412);
        bopoMap.put("kuai", -16407);
        bopoMap.put("kuan", -16403);
        bopoMap.put("kuang", -16401);
        bopoMap.put("kui", -16393);
        bopoMap.put("kun", -16220);
        bopoMap.put("kuo", -16216);
        bopoMap.put("la", -16212);
        bopoMap.put("lai", -16205);
        bopoMap.put("lan", -16202);
        bopoMap.put("lang", -16187);
        bopoMap.put("lao", -16180);
        bopoMap.put("le", -16171);
        bopoMap.put("lei", -16169);
        bopoMap.put("leng", -16158);
        bopoMap.put("li", -16155);
        bopoMap.put("lia", -15959);
        bopoMap.put("lian", -15958);
        bopoMap.put("liang", -15944);
        bopoMap.put("liao", -15933);
        bopoMap.put("lie", -15920);
        bopoMap.put("lin", -15915);
        bopoMap.put("ling", -15903);
        bopoMap.put("liu", -15889);
        bopoMap.put("long", -15878);
        bopoMap.put("lou", -15707);
        bopoMap.put("lu", -15701);
        bopoMap.put("lv", -15681);
        bopoMap.put("luan", -15667);
        bopoMap.put("lue", -15661);
        bopoMap.put("lun", -15659);
        bopoMap.put("luo", -15652);
        bopoMap.put("ma", -15640);
        bopoMap.put("mai", -15631);
        bopoMap.put("man", -15625);
        bopoMap.put("mang", -15454);
        bopoMap.put("mao", -15448);
        bopoMap.put("me", -15436);
        bopoMap.put("mei", -15435);
        bopoMap.put("men", -15419);
        bopoMap.put("meng", -15416);
        bopoMap.put("mi", -15408);
        bopoMap.put("mian", -15394);
        bopoMap.put("miao", -15385);
        bopoMap.put("mie", -15377);
        bopoMap.put("min", -15375);
        bopoMap.put("ming", -15369);
        bopoMap.put("miu", -15363);
        bopoMap.put("mo", -15362);
        bopoMap.put("mou", -15183);
        bopoMap.put("mu", -15180);
        bopoMap.put("na", -15165);
        bopoMap.put("nai", -15158);
        bopoMap.put("nan", -15153);
        bopoMap.put("nang", -15150);
        bopoMap.put("nao", -15149);
        bopoMap.put("ne", -15144);
        bopoMap.put("nei", -15143);
        bopoMap.put("nen", -15141);
        bopoMap.put("neng", -15140);
        bopoMap.put("ni", -15139);
        bopoMap.put("nian", -15128);
        bopoMap.put("niang", -15121);
        bopoMap.put("niao", -15119);
        bopoMap.put("nie", -15117);
        bopoMap.put("nin", -15110);
        bopoMap.put("ning", -15109);
        bopoMap.put("niu", -14941);
        bopoMap.put("nong", -14937);
        bopoMap.put("nu", -14933);
        bopoMap.put("nv", -14930);
        bopoMap.put("nuan", -14929);
        bopoMap.put("nue", -14928);
        bopoMap.put("nuo", -14926);
        bopoMap.put("o", -14922);
        bopoMap.put("ou", -14921);
        bopoMap.put("pa", -14914);
        bopoMap.put("pai", -14908);
        bopoMap.put("pan", -14902);
        bopoMap.put("pang", -14894);
        bopoMap.put("pao", -14889);
        bopoMap.put("pei", -14882);
        bopoMap.put("pen", -14873);
        bopoMap.put("peng", -14871);
        bopoMap.put("pi", -14857);
        bopoMap.put("pian", -14678);
        bopoMap.put("piao", -14674);
        bopoMap.put("pie", -14670);
        bopoMap.put("pin", -14668);
        bopoMap.put("ping", -14663);
        bopoMap.put("po", -14654);
        bopoMap.put("pu", -14645);
        bopoMap.put("qi", -14630);
        bopoMap.put("qia", -14594);
        bopoMap.put("qian", -14429);
        bopoMap.put("qiang", -14407);
        bopoMap.put("qiao", -14399);
        bopoMap.put("qie", -14384);
        bopoMap.put("qin", -14379);
        bopoMap.put("qing", -14368);
        bopoMap.put("qiong", -14355);
        bopoMap.put("qiu", -14353);
        bopoMap.put("qu", -14345);
        bopoMap.put("quan", -14170);
        bopoMap.put("que", -14159);
        bopoMap.put("qun", -14151);
        bopoMap.put("ran", -14149);
        bopoMap.put("rang", -14145);
        bopoMap.put("rao", -14140);
        bopoMap.put("re", -14137);
        bopoMap.put("ren", -14135);
        bopoMap.put("reng", -14125);
        bopoMap.put("ri", -14123);
        bopoMap.put("rong", -14122);
        bopoMap.put("rou", -14112);
        bopoMap.put("ru", -14109);
        bopoMap.put("ruan", -14099);
        bopoMap.put("rui", -14097);
        bopoMap.put("run", -14094);
        bopoMap.put("ruo", -14092);
        bopoMap.put("sa", -14090);
        bopoMap.put("sai", -14087);
        bopoMap.put("san", -14083);
        bopoMap.put("sang", -13917);
        bopoMap.put("sao", -13914);
        bopoMap.put("se", -13910);
        bopoMap.put("sen", -13907);
        bopoMap.put("seng", -13906);
        bopoMap.put("sha", -13905);
        bopoMap.put("shai", -13896);
        bopoMap.put("shan", -13894);
        bopoMap.put("shang", -13878);
        bopoMap.put("shao", -13870);
        bopoMap.put("she", -13859);
        bopoMap.put("shen", -13847);
        bopoMap.put("sheng", -13831);
        bopoMap.put("shi", -13658);
        bopoMap.put("shou", -13611);
        bopoMap.put("shu", -13601);
        bopoMap.put("shua", -13406);
        bopoMap.put("shuai", -13404);
        bopoMap.put("shuan", -13400);
        bopoMap.put("shuang", -13398);
        bopoMap.put("shui", -13395);
        bopoMap.put("shun", -13391);
        bopoMap.put("shuo", -13387);
        bopoMap.put("si", -13383);
        bopoMap.put("song", -13367);
        bopoMap.put("sou", -13359);
        bopoMap.put("su", -13356);
        bopoMap.put("suan", -13343);
        bopoMap.put("sui", -13340);
        bopoMap.put("sun", -13329);
        bopoMap.put("suo", -13326);
        bopoMap.put("ta", -13318);
        bopoMap.put("tai", -13147);
        bopoMap.put("tan", -13138);
        bopoMap.put("tang", -13120);
        bopoMap.put("tao", -13107);
        bopoMap.put("te", -13096);
        bopoMap.put("teng", -13095);
        bopoMap.put("ti", -13091);
        bopoMap.put("tian", -13076);
        bopoMap.put("tiao", -13068);
        bopoMap.put("tie", -13063);
        bopoMap.put("ting", -13060);
        bopoMap.put("tong", -12888);
        bopoMap.put("tou", -12875);
        bopoMap.put("tu", -12871);
        bopoMap.put("tuan", -12860);
        bopoMap.put("tui", -12858);
        bopoMap.put("tun", -12852);
        bopoMap.put("tuo", -12849);
        bopoMap.put("wa", -12838);
        bopoMap.put("wai", -12831);
        bopoMap.put("wan", -12829);
        bopoMap.put("wang", -12812);
        bopoMap.put("wei", -12802);
        bopoMap.put("wen", -12607);
        bopoMap.put("weng", -12597);
        bopoMap.put("wo", -12594);
        bopoMap.put("wu", -12585);
        bopoMap.put("xi", -12556);
        bopoMap.put("xia", -12359);
        bopoMap.put("xian", -12346);
        bopoMap.put("xiang", -12320);
        bopoMap.put("xiao", -12300);
        bopoMap.put("xie", -12120);
        bopoMap.put("xin", -12099);
        bopoMap.put("xing", -12089);
        bopoMap.put("xiong", -12074);
        bopoMap.put("xiu", -12067);
        bopoMap.put("xu", -12058);
        bopoMap.put("xuan", -12039);
        bopoMap.put("xue", -11867);
        bopoMap.put("xun", -11861);
        bopoMap.put("ya", -11847);
        bopoMap.put("yan", -11831);
        bopoMap.put("yang", -11798);
        bopoMap.put("yao", -11781);
        bopoMap.put("ye", -11604);
        bopoMap.put("yi", -11589);
        bopoMap.put("yin", -11536);
        bopoMap.put("ying", -11358);
        bopoMap.put("yo", -11340);
        bopoMap.put("yong", -11339);
        bopoMap.put("you", -11324);
        bopoMap.put("yu", -11303);
        bopoMap.put("yuan", -11097);
        bopoMap.put("yue", -11077);
        bopoMap.put("yun", -11067);
        bopoMap.put("za", -11055);
        bopoMap.put("zai", -11052);
        bopoMap.put("zan", -11045);
        bopoMap.put("zang", -11041);
        bopoMap.put("zao", -11038);
        bopoMap.put("ze", -11024);
        bopoMap.put("zei", -11020);
        bopoMap.put("zen", -11019);
        bopoMap.put("zeng", -11018);
        bopoMap.put("zha", -11014);
        bopoMap.put("zhai", -10838);
        bopoMap.put("zhan", -10832);
        bopoMap.put("zhang", -10815);
        bopoMap.put("zhao", -10800);
        bopoMap.put("zhe", -10790);
        bopoMap.put("zhen", -10780);
        bopoMap.put("zheng", -10764);
        bopoMap.put("zhi", -10587);
        bopoMap.put("zhong", -10544);
        bopoMap.put("zhou", -10533);
        bopoMap.put("zhu", -10519);
        bopoMap.put("zhua", -10331);
        bopoMap.put("zhuai", -10329);
        bopoMap.put("zhuan", -10328);
        bopoMap.put("zhuang", -10322);
        bopoMap.put("zhui", -10315);
        bopoMap.put("zhun", -10309);
        bopoMap.put("zhuo", -10307);
        bopoMap.put("zi", -10296);
        bopoMap.put("zong", -10281);
        bopoMap.put("zou", -10274);
        bopoMap.put("zu", -10270);
        bopoMap.put("zuan", -10262);
        bopoMap.put("zui", -10260);
        bopoMap.put("zun", -10256);
        bopoMap.put("zuo", -10254);
        bopoMap.put("", -10246);
    }

    public static String hex2bin(String hex) {
        if (hex != null) {
            return map_hex2bin.get(hex.toUpperCase());
        }
        return null;
    }

    public static String hexstr2bin(String hex) {
        String result = null;
        if (hex != null) {
            if (!GFString.isHex(hex)) {
                return null;
            }
            hex = String.valueOf(hex) + "0";
            result = "";
            int i = 0;
            while (i < hex.length() - 1) {
                result = String.valueOf(result) + GFString.hex2bin(hex.substring(i, i + 1));
                ++i;
            }
        }
        return result;
    }

    public static boolean isHex(String hex) {
        if (hex != null) {
            hex = hex.toUpperCase();
            int i = 0;
            while (i < hex.length()) {
                char value = hex.charAt(i);
                if (value < '0' || value > '9' && value < 'A' || value > 'F') {
                    return false;
                }
                ++i;
            }
        } else {
            return false;
        }
        return true;
    }

    public static byte[] getBytes(String str, int start, int len) {
        byte[] b = null;
        if (str != null) {
            byte[] b1 = str.getBytes();
            b = GFCommon.bytesCopy(b1, start, len);
        }
        return b;
    }

    public static String getEncodedString(byte[] bArray, String charsetName) {
        String ch = null;
        if (charsetName != null) {
            try {
                ch = new String(bArray, charsetName);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return ch;
    }

    public static long hexstr2long(String hex) {
        long value = 0L;
        if (hex != null) {
            if ((hex = hex.toUpperCase()).length() > 16) {
                hex = hex.substring(0, 16);
            }
            if (GFString.isHex(hex)) {
                byte[] b = GFString.hexstr2bytes(hex);
                value = GFCommon.bytes2long(b);
            }
        }
        return value;
    }

    public static String getFixedLenStr(String str, int len, char appendChar) {
        if (str == null || len < 0) {
            return null;
        }
        int strLen = 0;
        strLen = str.length();
        if (len <= strLen) {
            str = String.valueOf(str) + appendChar;
            return str.substring(0, len);
        }
        int i = 0;
        while (i < len - strLen) {
            str = String.valueOf(appendChar) + str;
            ++i;
        }
        return str;
    }

    public static long bin2long(String bs) {
        long value = 0L;
        if (bs != null && bs.length() <= 64) {
            byte[] b = GFString.bin2bytes(bs);
            value = GFCommon.bytes2long(b);
        }
        return value;
    }

    public static String bin2hex(String bin) {
        String hex = null;
        if (bin != null && bin.length() <= 4 && GFString.isBinstr(bin)) {
            int i = 0;
            while (i < 4 - bin.length()) {
                bin = "0" + bin;
                ++i;
            }
            hex = map_bin2hex.get(bin);
        }
        return hex;
    }

    public static String bin2hexstr(String bin) {
        String hex = null;
        if (bin != null && GFString.isBinstr(bin)) {
            int ys = bin.length() % 4;
            int i = 0;
            while (ys != 0 && i < 4 - ys) {
                bin = "0" + bin;
                ++i;
            }
            bin = String.valueOf(bin) + "0";
            hex = "";
            i = 0;
            while (i < bin.length() - 4) {
                String h = GFString.bin2hex(bin.substring(i, i + 4));
                if (h != null) {
                    if (h.equals("0")) {
                        if (!hex.equals("")) {
                            hex = String.valueOf(hex) + h;
                        }
                    } else {
                        hex = String.valueOf(hex) + h;
                    }
                }
                i += 4;
            }
            if (hex.equals("")) {
                hex = "0";
            }
        }
        return hex;
    }

    public static byte bin2byte(String bin) {
        byte b = 0;
        if (bin != null && bin.length() <= 8 && GFString.isBinstr(bin)) {
            String hex = GFString.bin2hexstr(bin);
            b = GFString.hex2byte(hex);
        }
        return b;
    }

    public static byte[] bin2bytes(String bin) {
        byte[] bs = null;
        if (bin != null) {
            String hex = GFString.bin2hexstr(bin);
            bs = GFString.hexstr2bytes(hex);
        }
        return bs;
    }

    public static int bin2int(String bin) {
        int value = 0;
        if (bin != null && bin.length() <= 32 && GFString.isBinstr(bin)) {
            String hex = GFString.bin2hexstr(bin);
            value = GFString.hexstr2int(hex);
        }
        return value;
    }

    public static boolean isBinstr(String bin) {
        boolean result = false;
        if (bin != null) {
            byte[] b = bin.getBytes();
            int i = 0;
            while (i < b.length) {
                if (b[i] != 48 && b[i] != 49) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return result;
    }

    public static boolean isNumeric(String str) {
        if (str != null) {
            try {
                str = str.trim();
                double d = Double.parseDouble(str);
                d += 1.0;
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isAllChinese(String str) {
        return str != null && (str = GFString.quan2ban(str)) != null && str.length() * 2 == str.getBytes().length;
    }

    public static boolean isNoChinese(String str) {
        return str != null && (str = GFString.quan2ban(str)) != null && str.length() == str.getBytes().length;
    }

    public static boolean isLetter(String str) {
        if (str != null) {
            str = str.trim();
            byte[] b = str.toUpperCase().getBytes();
            int i = 0;
            while (i < b.length) {
                if (b[i] < 65 || b[i] > 90) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static String int2bin(int value) {
        if (value >= 0 && value < 256) {
            String bin = Integer.toBinaryString(value);
            int len = bin.length();
            int i = 0;
            while (i < 8 - len) {
                bin = "0" + bin;
                ++i;
            }
            return bin;
        }
        return null;
    }

    public static int cint(String str) {
        if (str != null) {
            try {
                int i = new Integer(str);
                return i;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static long clong(String str) {
        if (str != null) {
            try {
                return new Long(str);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1L;
    }

    public static String substr(String str, int begin, int len) {
        if (str == null) {
            return null;
        }
        int strLen = 0;
        strLen = str.length();
        if (begin >= strLen) {
            return null;
        }
        if (len > strLen) {
            return null;
        }
        str = String.valueOf(str) + "0";
        try {
            return str.substring(begin, len);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public static String bytes2hex(byte[] b) {
        String result = "";
        if (b != null && b.length > 0) {
            int i = 0;
            while (i < b.length) {
                int value = b[i] >>> 4 & 0xF;
                result = String.valueOf(result) + Integer.toHexString(value);
                value = b[i] & 0xF;
                result = String.valueOf(result) + Integer.toHexString(value);
                ++i;
            }
        }
        return result.toUpperCase();
    }

    public static String unicode2gb(String hexString) {
        StringBuffer sb = new StringBuffer();
        if (hexString == null) {
            return null;
        }
        int i = 0;
        while (i + 4 <= hexString.length()) {
            try {
                int j = Integer.parseInt(hexString.substring(i, i + 4), 16);
                sb.append((char)j);
            }
            catch (NumberFormatException e) {
                return hexString;
            }
            i += 4;
        }
        return sb.toString();
    }

    public static String gb2unicode(String gbString) {
        String result = "";
        if (gbString == null) {
            return null;
        }
        String temp = null;
        char[] c = new char[gbString.length()];
        StringBuffer sb = new StringBuffer(gbString);
        sb.getChars(0, sb.length(), c, 0);
        int i = 0;
        while (i < c.length) {
            char value = c[i];
            temp = Integer.toHexString(value);
            result = String.valueOf(result) + GFString.fill(temp, 4);
            ++i;
        }
        return result.toUpperCase();
    }

    public static String fill(String src, int len) {
        String result = null;
        if (src != null && src.length() <= len) {
            result = src;
            int i = 0;
            while (i < len - src.length()) {
                result = "0" + result;
                ++i;
            }
        }
        return result;
    }

    public static String insert(String src, String insertStr, int index) {
        String result = src;
        if (src != null && insertStr != null) {
            String temp = null;
            if (index < 0) {
                if (index * -1 > src.length()) {
                    result = String.valueOf(insertStr) + src;
                } else {
                    temp = src.substring(src.length() + index + 1);
                    result = String.valueOf(src.substring(0, src.length() + index + 1)) + insertStr + temp;
                }
            } else if (index >= src.length()) {
                result = String.valueOf(src) + insertStr;
            } else {
                temp = src.substring(index);
                result = String.valueOf(src.substring(0, index)) + insertStr + temp;
            }
        } else if (src == null && insertStr != null) {
            result = insertStr;
        }
        return result;
    }

    public static String interChange(String src) {
        String result = null;
        if (src != null) {
            if (src.length() % 2 != 0) {
                src = String.valueOf(src) + "F";
            }
            src = String.valueOf(src) + "0";
            result = "";
            int i = 0;
            while (i < src.length() - 2) {
                result = String.valueOf(result) + src.substring(i + 1, i + 2);
                result = String.valueOf(result) + src.substring(i, i + 1);
                i += 2;
            }
        }
        return result;
    }

    public static String bytes2str(byte[] b, String encoding) {
        String result = null;
        int actualLen = 0;
        if (b != null && b.length > 0) {
            int i = 0;
            while (i < b.length) {
                if (b[i] == 0) break;
                ++actualLen;
                ++i;
            }
            byte[] ab = GFCommon.bytesCopy(b, 0, actualLen);
            try {
                result = new String(ab, encoding);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static String[] split(String src, int intervalLen) {
        String[] result = null;
        int len = 0;
        if (src != null && intervalLen > 0) {
            len = src.length() / intervalLen;
            if (src.length() % intervalLen != 0) {
                ++len;
            }
            result = new String[len];
            int i = 0;
            int j = 0;
            while (i < len - 1) {
                result[i] = src.substring(j, j + intervalLen);
                ++i;
                j += intervalLen;
            }
            result[len - 1] = src.substring((len - 1) * intervalLen);
        }
        return result;
    }

    public static String bytes2hexstr(byte[] b) {
        return GFString.bytes2hexstr(b, false);
    }

    public static String bytes2hexstr(byte[] b, boolean highBitFirst) {
        String result = null;
        if (b != null && b.length > 0) {
            if (highBitFirst) {
                int i = b.length - 1;
                while (i >= 0) {
                    String hex = GFString.byte2hex(b[i]);
                    result = result == null ? hex : String.valueOf(result) + hex;
                    --i;
                }
                result = result.toUpperCase();
            } else {
                int i = 0;
                while (i < b.length) {
                    String hex = GFString.byte2hex(b[i]);
                    result = result == null ? hex : String.valueOf(result) + hex;
                    ++i;
                }
                result = result.toUpperCase();
            }
        }
        return result;
    }

    public static String bytes2hexstr(byte[] b, int len) {
        String result = null;
        if (b != null && b.length > 0 && len <= b.length) {
            int i = 0;
            while (i < len) {
                String hex = GFString.byte2hex(b[i]);
                result = result == null ? hex : String.valueOf(result) + hex;
                ++i;
            }
            result = result.toUpperCase();
        }
        return result;
    }

    public static byte[] hexstr2bytes(String hexstr) {
        byte[] b = null;
        int len = 0;
        if (hexstr != null) {
            if (hexstr.length() % 2 != 0) {
                hexstr = "0" + hexstr;
            }
            len = hexstr.length() / 2;
            b = new byte[len];
            String temp = String.valueOf(hexstr) + "0";
            int i = 0;
            int j = 0;
            while (i < temp.length() - 2) {
                b[j] = GFString.hex2byte(temp.substring(i, i + 2));
                i += 2;
                ++j;
            }
        }
        return b;
    }

    public static int hexstr2int(String hex) {
        if (hex != null && hex.length() <= 8) {
            hex = hex.toUpperCase();
            int i = 0;
            while (i < hex.length()) {
                char value = hex.charAt(i);
                if (value < '0' || value > '9' && value < 'A' || value > 'F') {
                    return 0;
                }
                ++i;
            }
            byte[] b = GFString.hexstr2bytes(hex);
            return GFCommon.bytes2int(b);
        }
        return 0;
    }

    public static String getChineseString(byte[] bArray, String charsetName) {
        String ch = null;
        if (charsetName != null) {
            try {
                ch = new String(bArray, charsetName);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return ch;
    }

    public static String bytes2str(byte[] b) {
        String result = null;
        int actualLen = 0;
        if (b != null && b.length > 0) {
            int i = 0;
            while (i < b.length) {
                if (b[i] == 0) break;
                ++actualLen;
                ++i;
            }
            byte[] b2 = GFCommon.bytesCopy(b, 0, actualLen);
            if (b2 != null && b2.length > 0) {
                result = new String(b2);
            }
        }
        return result;
    }

    public static String int2str(int value, int len) {
        String result = "" + value;
        int l = result.length();
        if (len >= 0) {
            if (l <= len) {
                int i = 0;
                while (i < len - l) {
                    result = "0" + result;
                    ++i;
                }
            } else {
                result = result.substring(0, len);
            }
        }
        return result;
    }

    public static byte hex2byte(String hex) {
        byte b = 0;
        char value = '\u0000';
        if (hex != null && hex.length() <= 2) {
            if ((hex = hex.toUpperCase()).length() == 0) {
                return 0;
            }
            if (hex.length() >= 1) {
                value = hex.charAt(0);
                if (value < '0' || value > '9' && value < 'A' || value > 'F') {
                    return 0;
                }
                if (hex.length() == 2 && ((value = hex.charAt(1)) < '0' || value > '9' && value < 'A' || value > 'F')) {
                    return 0;
                }
            }
            try {
                b = (byte)Integer.parseInt(hex, 16);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return b;
    }

    public static String byte2hex(byte b) {
        String result = null;
        result = Integer.toHexString(b >> 4 & 0xF);
        result = String.valueOf(result) + Integer.toHexString(b & 0xF);
        return result.toUpperCase();
    }

    public static String quan2ban(String str) {
        String result = null;
        if (str != null) {
            try {
                byte[] uniBytes = str.getBytes("utf-16be");
                byte[] b = new byte[uniBytes.length];
                int i = 0;
                while (i < b.length) {
                    if (uniBytes[i] == -1) {
                        b[i] = 0;
                        if (i + 1 < uniBytes.length) {
                            b[++i] = (byte)(uniBytes[i] + 32);
                        }
                    } else {
                        b[i] = uniBytes[i];
                    }
                    ++i;
                }
                result = new String(b, "utf-16be");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static String ban2quan(String str) {
        String result = null;
        if (str != null) {
            try {
                byte[] uniBytes = str.getBytes("utf-16be");
                byte[] b = new byte[uniBytes.length];
                int i = 0;
                while (i < b.length) {
                    if (uniBytes[i] == 0) {
                        b[i] = -1;
                        if (i + 1 < uniBytes.length) {
                            b[++i] = (byte)(uniBytes[i] - 32);
                        }
                    } else {
                        b[i] = uniBytes[i];
                    }
                    ++i;
                }
                result = new String(b, "utf-16be");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static String quan2banGBK(String str) {
        String result = null;
        if (str != null) {
            try {
                int j = 0;
                byte[] uniBytes = str.getBytes("GBK");
                byte[] b = new byte[uniBytes.length];
                int i = 0;
                while (i < b.length) {
                    if (uniBytes[i] == -93) {
                        if (i + 1 < uniBytes.length) {
                            b[j] = (byte)(uniBytes[++i] - 128);
                        }
                    } else {
                        b[j] = uniBytes[i];
                        if (uniBytes[i] < 0 && i + 1 < b.length) {
                            b[++j] = uniBytes[++i];
                        }
                    }
                    ++j;
                    ++i;
                }
                result = new String(b, 0, j, "GBK");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static String ban2quanGBK(String str) {
        String result = null;
        if (str != null) {
            try {
                int j = 0;
                byte[] uniBytes = str.getBytes("GBK");
                byte[] b = new byte[uniBytes.length * 2];
                int i = 0;
                while (i < uniBytes.length) {
                    if (uniBytes[i] >= 0) {
                        b[j] = -93;
                        if (j + 1 < b.length) {
                            b[++j] = (byte)(uniBytes[i] + 128);
                        }
                    } else {
                        b[j] = uniBytes[i];
                        if (i + 1 < uniBytes.length && j + 1 < b.length) {
                            b[++j] = uniBytes[++i];
                        }
                    }
                    ++j;
                    ++i;
                }
                result = new String(b, 0, j, "GBK");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static String removeSpace(String s) {
        String rs = null;
        String s1 = null;
        if (s != null) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < s.length()) {
                s1 = s.substring(i, i + 1);
                if (!s1.equals(" ")) {
                    sb.append(s1);
                }
                ++i;
            }
            rs = sb.toString();
        }
        return rs;
    }

    public static String formatSpace(String src) {
        String result = null;
        if (src != null) {
            result = "";
            String[] ss = src.split(" ");
            int i = 0;
            while (i < ss.length) {
                if (ss[i] != null && ss[i].length() > 0) {
                    result = String.valueOf(result) + ss[i] + " ";
                }
                ++i;
            }
            if (result.length() > 0 && result.substring(result.length() - 1).equals(" ")) {
                result = result.substring(0, result.length() - 1);
            }
        }
        return result;
    }

    public static String encode7bit(String src) {
        String result = null;
        String hex = null;
        if (src != null && src.length() == src.getBytes().length) {
            result = "";
            byte left = 0;
            byte[] b = src.getBytes();
            int i = 0;
            int j = 0;
            while (i < b.length) {
                j = i & 7;
                if (j == 0) {
                    left = b[i];
                } else {
                    byte value = (byte)(b[i] << 8 - j | left);
                    left = (byte)(b[i] >> j);
                    hex = GFString.byte2hex(value);
                    result = String.valueOf(result) + hex;
                    if (i == b.length - 1) {
                        result = String.valueOf(result) + GFString.byte2hex(left);
                    }
                }
                ++i;
            }
            result = result.toUpperCase();
        }
        return result;
    }

    public static String decode7bit(String src) {
        String result = null;
        String temp = null;
        int left = 0;
        if (src != null && src.length() % 2 == 0) {
            result = "";
            int[] b = new int[src.length() / 2];
            temp = String.valueOf(src) + "0";
            int i = 0;
            int j = 0;
            int k = 0;
            while (i < temp.length() - 2) {
                b[j] = Integer.parseInt(temp.substring(i, i + 2), 16);
                k = j % 7;
                byte srcAscii = (byte)(b[j] << k & 0x7F | left);
                result = String.valueOf(result) + (char)srcAscii;
                left = (byte)(b[j] >>> 7 - k);
                if (k == 6) {
                    result = String.valueOf(result) + (char)left;
                    left = 0;
                }
                if (j == src.length() / 2) {
                    result = String.valueOf(result) + (char)left;
                }
                i += 2;
                ++j;
            }
        }
        return result;
    }

    public static boolean isMobileNo(String msg) {
        return msg != null && msg.length() == 11 && GFString.isNumeric(msg) && (msg.substring(0, 2).equals("13") || msg.substring(0, 2).equals("15"));
    }

    public static boolean isTelNo(String msg) {
        if (msg != null && msg.length() >= 7) {
            String temp = String.valueOf(msg) + " ";
            String t = null;
            int i = 0;
            while (i < temp.length() - 1) {
                t = temp.substring(i, i + 1);
                if (!GFString.isNumeric(t)) {
                    temp = String.valueOf(temp.substring(0, i)) + " " + temp.substring(i + 1);
                }
                ++i;
            }
            msg = GFString.removeSpace(temp);
            if (GFString.isNumeric(msg) && msg.length() >= 7 && msg.length() <= 12) {
                if (msg.substring(0, 1).equals("0")) {
                    if (msg.length() >= 10) {
                        return true;
                    }
                } else {
                    if (GFString.isMobileNo(msg)) {
                        return true;
                    }
                    if (msg.length() <= 8) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static String getAnteriorNotSpaceChar(String msg, int index) {
        String ch = null;
        if (msg != null && index > 0) {
            int i = index - 1;
            while (i >= 0) {
                String s = msg.substring(i, i + 1);
                if (!s.equals(" ")) {
                    return s;
                }
                --i;
            }
        }
        return ch;
    }

    public static ArrayList<String> sortByLen(ArrayList<String> list, boolean long2short) {
        ArrayList<String> rs = null;
        if (list != null) {
            rs = new ArrayList<String>(list.size());
            block0: for (String name : list) {
                if ((name = GFString.removeSpace(name)) == null || name.length() <= 1) continue;
                if (rs.size() > 0) {
                    int i = 0;
                    while (i < rs.size()) {
                        if (name.length() >= ((String)rs.get(i)).length()) {
                            rs.add(i, name);
                            continue block0;
                        }
                        if (i == rs.size() - 1) {
                            rs.add(name);
                            continue block0;
                        }
                        ++i;
                    }
                    continue;
                }
                rs.add(name);
            }
            if (!long2short) {
                ArrayList<String> rs2 = new ArrayList<String>();
                for (String s : rs) {
                    rs2.add(0, s);
                }
                rs = rs2;
            }
        }
        return rs;
    }

    public static String replace(String src, int index, int len, String newstr) {
        String result = src;
        if (src != null && index >= 0 && index < src.length()) {
            if (newstr == null) {
                newstr = "";
            }
            String p1 = src.substring(0, index);
            if (index + len >= src.length()) {
                result = String.valueOf(p1) + newstr;
            } else {
                String p2 = src.substring(index + len);
                result = String.valueOf(p1) + newstr + p2;
            }
        }
        return result;
    }

    public static boolean hasZero(String msg) {
        if (msg != null) {
            byte[] bb;
            byte[] byArray = bb = msg.getBytes();
            int n = bb.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                if (b == 0) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean isAlphanumeric(String str) {
        if (str != null) {
            byte[] bs;
            byte[] byArray = bs = str.getBytes();
            int n = bs.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                if (b < 48 || b > 57 && b < 65 || b > 90 && b < 97 || b > 122) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public static String removePlacenameSuffix(String placename) {
        int index = -1;
        String[] suffix = new String[]{"\u7701", "\u5e02", "\u533a", "\u53bf", "\u4e61", "\u9547", "\u6751"};
        if (placename != null && placename.length() > 1) {
            String[] stringArray = suffix;
            int n = suffix.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                index = placename.indexOf(s);
                if (placename.length() > 2 && index == placename.length() - 1) {
                    placename = placename.substring(0, index);
                    break;
                }
                ++n2;
            }
        }
        return placename;
    }

    public static String addPlacenameSuffix(String placename, String suffix) {
        int index = -1;
        if (placename != null && placename.length() > 1 && suffix != null && suffix.length() == 1 && (index = placename.indexOf(suffix)) != placename.length() - 1) {
            placename = String.valueOf(placename) + suffix;
        }
        return placename;
    }

    public static boolean isBefore(String str1, String str2) {
        boolean rs = false;
        if (str1 != null && str2 != null) {
            int len = str1.length() < str2.length() ? str1.length() : str2.length();
            byte[] b1 = str1.getBytes();
            byte[] b2 = str2.getBytes();
            int i = 0;
            while (i < len) {
                if (b2[i] > b1[i]) {
                    return true;
                }
                if (b2[i] < b1[i]) {
                    return false;
                }
                ++i;
            }
        }
        return rs;
    }

    public static boolean isUnicommMobile(String sim) {
        String part;
        boolean result = false;
        if (sim != null && sim.length() == 11 && ((part = sim.substring(0, 3)).equals("130") || part.equals("131") || part.equals("132") || part.equals("133") || part.equals("153") || part.equals("156"))) {
            result = true;
        }
        return result;
    }

    public static boolean isChinaMobile(String sim) {
        String part;
        boolean result = false;
        if (sim != null && sim.length() == 11 && ((part = sim.substring(0, 3)).equals("134") || part.equals("135") || part.equals("136") || part.equals("137") || part.equals("138") || part.equals("139") || part.equals("159") || part.equals("158"))) {
            result = true;
        }
        return result;
    }

    public static String getNextString(String str, int index) {
        Object rs = null;
        if (str != null && str.length() > 0) {
            rs = index < 0 ? (str.length() > 1 ? str.substring(0, 1) : str) : (index == str.length() - 1 ? null : (index == str.length() - 2 ? str.substring(index + 1) : str.substring(index + 1, index + 2)));
        }
        return rs;
    }

    public static String[] atomSplit(String str) {
        if (str == null) {
            return null;
        }
        String[] result = null;
        int nLen = str.length();
        result = new String[nLen];
        int i = 0;
        while (i < nLen) {
            result[i] = str.substring(i, i + 1);
            ++i;
        }
        return result;
    }

    public static boolean hasTelNo(String str) {
        if (str != null && str.length() >= 7) {
            String[] ss = GFString.atomSplit(GFString.quan2banGBK(str));
            String rs = "";
            String[] stringArray = ss;
            int n = ss.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if ("-".equals(s) || "/".equals(s) || "(".equals(s) || ")".equals(s) || GFString.isNumeric(s)) {
                    rs = String.valueOf(rs) + s;
                } else if (rs.length() > 0) break;
                ++n2;
            }
            if (rs.length() >= 7) {
                if (GFString.isMobileNo(rs)) {
                    return true;
                }
                if (GFString.isTelNo(rs)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static int findPos(String str, String pos) {
        int result = -1;
        if (str != null && pos != null) {
            int i = 0;
            while (i < str.length()) {
                int index = str.indexOf(pos, i);
                if (index + pos.length() == str.length() || index != -1 && str.substring(index + pos.length()).indexOf(" ") == 0) {
                    result = index;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public static String getPOSKey(String str) {
        int index;
        if (str != null && (index = str.indexOf("/")) > 0) {
            return str.substring(0, index);
        }
        return null;
    }

    public static String[] splitByPOS(String str) {
        String[] result = null;
        ArrayList<String> list = new ArrayList<String>();
        if (str != null) {
            String[] ss = str.split(" ");
            int i = 0;
            String[] stringArray = ss;
            int n = ss.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.indexOf("/") == 0 && i - 1 >= 0 && i - 1 < list.size()) {
                    String key = (String)list.get(i - 1);
                    list.set(i - 1, String.valueOf(key) + " " + s);
                } else {
                    list.add(s);
                    ++i;
                }
                ++n2;
            }
            result = new String[list.size()];
            list.toArray(result);
        }
        return result;
    }

    public static String getBopomofo(String cstr) {
        String bopomofo = null;
        if (cstr != null) {
            String[] atoms;
            bopomofo = "";
            String[] stringArray = atoms = GFString.atomSplit(cstr);
            int n = atoms.length;
            int n2 = 0;
            while (n2 < n) {
                String atom = stringArray[n2];
                if (GFString.isAllChinese(atom)) {
                    byte[] b = atom.getBytes();
                    int id = (256 + b[0]) * 256 + (256 + b[1]) - 65536;
                    int id1 = -20319;
                    int id2 = 0;
                    String last = null;
                    for (String py : bopoMap.keySet()) {
                        id2 = bopoMap.get(py);
                        if (id >= id1 && id < id2) {
                            bopomofo = String.valueOf(bopomofo) + (last == null ? py : last);
                            break;
                        }
                        last = py;
                        id1 = id2;
                    }
                } else {
                    bopomofo = String.valueOf(bopomofo) + atom;
                }
                ++n2;
            }
            bopomofo = bopomofo.toUpperCase();
        }
        return bopomofo;
    }

    public static int compareTo(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return 0;
        }
        if (s1 != null && s2 == null) {
            return 1;
        }
        if (s1 == null && s2 != null) {
            return -1;
        }
        int len = Math.min(s1.length(), s2.length());
        int i = 0;
        while (i < len) {
            String id1 = s1.substring(i, i + 1);
            String id2 = s2.substring(i, i + 1);
            int rs = GFString.getID(id1) - GFString.getID(id2);
            if (rs != 0) {
                return rs;
            }
            ++i;
        }
        if (s1.length() > s2.length()) {
            return 1;
        }
        if (s1.length() < s2.length()) {
            return -1;
        }
        return 0;
    }

    public static String getGB(int id) {
        String result = null;
        if (id >= 0 && id < 6768) {
            byte[] b = new byte[]{(byte)(id / 94 + 176), (byte)(id % 94 + 161)};
            try {
                result = new String(b, "GBK");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static int getGBID(String s) {
        int result = -1;
        if (s != null && s.length() == 1 && GFString.isAllChinese(s)) {
            byte[] b = s.getBytes();
            int high = b[0] + 256;
            int low = b[1] + 256;
            return (high - 176) * 94 + (low - 161);
        }
        return result;
    }

    public static int getID(String s) {
        int result = -1;
        if (s != null && s.length() == 1) {
            byte[] b = s.getBytes();
            if (b.length == 2) {
                int high = b[0] + 256;
                int low = b[1] + 256;
                return high * 256 + low;
            }
            return b[0];
        }
        return result;
    }

    public static String getTelcode(String telno) {
        String head = null;
        if (GFString.isTelNo(telno) && telno.length() > 7) {
            int len = telno.length();
            switch (len) {
                case 10: {
                    head = telno.substring(0, 3);
                    break;
                }
                case 11: {
                    if (telno.indexOf("01") == 0 || telno.indexOf("02") == 0) {
                        head = telno.substring(0, 3);
                        break;
                    }
                    head = telno.substring(0, 4);
                    break;
                }
                case 12: {
                    head = telno.indexOf("098") == 0 || telno.indexOf("094") == 0 && telno.indexOf("0943") == -1 || telno.indexOf("092") == 0 || telno.indexOf("086") == 0 || telno.indexOf("084") == 0 || telno.indexOf("0827") == 0 || telno.indexOf("0829") == 0 || telno.indexOf("0822") == 0 || telno.indexOf("0824") == 0 || telno.indexOf("080") == 0 || telno.indexOf("07437") == 0 || telno.indexOf("0483") == 0 || telno.indexOf("0788") == 0 ? telno.substring(0, 5) : telno.substring(0, 4);
                }
            }
        }
        return head;
    }

    public static String getPosWord(String src, int indexPos) {
        String result = null;
        if (src != null && indexPos > 0 && indexPos < src.length() - 1) {
            String temp = src.substring(0, indexPos + 1);
            String[] ss = temp.split(" ");
            int i = ss.length - 1;
            while (i >= 0) {
                int index = ss[i].indexOf("/");
                if (index == -1) break;
                if (index > 0) {
                    result = ss[i].substring(0, index);
                    break;
                }
                --i;
            }
        }
        return result;
    }

    public static String getFirstInt(String str) {
        String result = null;
        if (str != null) {
            String temp = "";
            String[] atoms = GFString.atomSplit(str);
            int i = 0;
            while (i < atoms.length) {
                if (GFString.isNumeric(atoms[i])) {
                    temp = String.valueOf(temp) + atoms[i];
                }
                if (i + 1 < atoms.length && !GFString.isNumeric(atoms[i + 1])) break;
                ++i;
            }
            if (temp.length() > 0) {
                result = temp;
            }
        }
        return result;
    }

    public static boolean hasDisorderChar(String msg) {
        if (msg != null) {
            String[] atoms = GFString.atomSplit(msg);
            int i = 0;
            while (i < atoms.length) {
                byte[] bs = atoms[i].getBytes();
                if (bs.length == 1 ? bs[0] < 32 || bs[0] > 126 : bs.length == 2 && (GFCommon.getUnsigned(bs[0]) < 129 || GFCommon.getUnsigned(bs[0]) > 254 || GFCommon.getUnsigned(bs[1]) < 40 || GFCommon.getUnsigned(bs[1]) > 254)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static String formatTime(long millisTime) {
        StringBuffer sb = new StringBuffer();
        sb.append((millisTime /= 1000L) / 3600L);
        sb.append("\u5c0f\u65f6");
        sb.append(millisTime % 3600L / 60L);
        sb.append("\u5206\u949f");
        sb.append(millisTime % 3600L % 60L);
        sb.append("\u79d2");
        return sb.toString();
    }

    public static ArrayList<String> readTxtFile2(String fileName) throws IOException {
        ArrayList<String> result = null;
        FileInputStream fin = null;
        InputStreamReader in = null;
        BufferedReader br = null;
        File file = null;
        String value = null;
        if (fileName != null && (file = new File(fileName)).exists()) {
            result = new ArrayList<String>();
            try {
                fin = new FileInputStream(file);
                in = new InputStreamReader(fin);
                br = new BufferedReader(in);
                while ((value = br.readLine()) != null) {
                    result.add(value);
                }
            }
            catch (IOException e) {
                throw new IOException();
            }
        }
        return result;
    }
}

