/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.util;

import cn.pconline.r.client.SimpleHttpTemplate;
import cn.pconline.r.route.Route;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.log4j.Logger;

public class Intf {
    private static Logger logger;
    public static String DEFAULT_ENCODING;
    public static int TIME_OUT;
    public static int CONNECT_TIME_OUT;
    public static int MAX_TOTAL_CONNECT;
    public static int RETRY_HANDLER_LIMIT;
    public static String[] DEFAULT_PROXY_CONFIG;
    public static String DEFAULT_REFERER_VALUE;
    public static String REFERER_KEY;
    private static SimpleHttpTemplate httpTemplate;
    private static HttpClient client;
    private static HttpClient client4Proxy;

    static {
        block13: {
            logger = Logger.getLogger(Intf.class);
            DEFAULT_ENCODING = "GBK";
            TIME_OUT = 30000;
            CONNECT_TIME_OUT = 30000;
            MAX_TOTAL_CONNECT = 80;
            RETRY_HANDLER_LIMIT = 1;
            DEFAULT_PROXY_CONFIG = new String[]{"192.168.239.200", "1080", "pic", "iLualt"};
            DEFAULT_REFERER_VALUE = "http://ks.pconline.com.cn";
            REFERER_KEY = "Referer";
            InitialContext context = null;
            try {
                try {
                    context = new InitialContext();
                    Object obj = context.lookup("java:comp/env/jca/pc_route");
                    if (obj != null && obj instanceof Route) {
                        httpTemplate = new SimpleHttpTemplate();
                        httpTemplate.setClientUri(DEFAULT_REFERER_VALUE);
                        httpTemplate.setConnectTimeout(CONNECT_TIME_OUT);
                        httpTemplate.setMaxPerRoute(3);
                        httpTemplate.setMaxTotalConnections(MAX_TOTAL_CONNECT);
                        httpTemplate.setReadTimeout(TIME_OUT);
                        httpTemplate.setRoute((Route)obj);
                        httpTemplate.init();
                    }
                }
                catch (Throwable e) {
                    logger.error((Object)e.getMessage(), e);
                    if (context == null) break block13;
                    try {
                        context.close();
                    }
                    catch (NamingException e2) {
                        logger.error((Object)"close context error", (Throwable)e2);
                    }
                }
            }
            finally {
                if (context != null) {
                    try {
                        context.close();
                    }
                    catch (NamingException e) {
                        logger.error((Object)"close context error", (Throwable)e);
                    }
                }
            }
        }
    }

    private static void genHttpClient(String[] proxyConfig, int timeout, int retry) {
        if (proxyConfig != null && proxyConfig.length == 4) {
            if (client4Proxy == null) {
                BasicHttpParams params = new BasicHttpParams();
                params.setParameter("http.connection.timeout", (Object)CONNECT_TIME_OUT);
                params.setParameter("http.socket.timeout", (Object)TIME_OUT);
                ThreadSafeClientConnManager manager = new ThreadSafeClientConnManager();
                manager.setMaxTotal(MAX_TOTAL_CONNECT);
                client4Proxy = new DefaultHttpClient((ClientConnectionManager)manager, (HttpParams)params);
                HttpHost proxy = new HttpHost(proxyConfig[0], Integer.parseInt(proxyConfig[1]));
                client4Proxy.getParams().setParameter("http.route.default-proxy", (Object)proxy);
                NTCredentials credentials = new NTCredentials(proxyConfig[2], proxyConfig[3], "", "");
                ((DefaultHttpClient)client4Proxy).getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)credentials);
                logger.info((Object)(String.valueOf(proxyConfig[0]) + "," + proxyConfig[1] + "," + proxyConfig[0] + "," + proxyConfig[2] + "," + proxyConfig[3]));
            }
            if (retry > 0) {
                ((DefaultHttpClient)client4Proxy).setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(retry, true));
            }
        } else {
            if (client == null) {
                BasicHttpParams params = new BasicHttpParams();
                params.setParameter("http.connection.timeout", (Object)CONNECT_TIME_OUT);
                params.setParameter("http.socket.timeout", (Object)TIME_OUT);
                ThreadSafeClientConnManager manager = new ThreadSafeClientConnManager();
                manager.setMaxTotal(MAX_TOTAL_CONNECT);
                client = new DefaultHttpClient((ClientConnectionManager)manager, (HttpParams)params);
            }
            if (retry > 0) {
                ((DefaultHttpClient)client).setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(retry, true));
            }
        }
    }

    private static HttpClient genSingleHttpClient(String[] proxyConfig, String charset, int timeout, int retry) {
        DefaultHttpClient singleClient = new DefaultHttpClient();
        if (proxyConfig != null && proxyConfig.length == 4) {
            HttpHost proxy = new HttpHost(proxyConfig[0], Integer.parseInt(proxyConfig[1]));
            singleClient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            NTCredentials credentials = new NTCredentials(proxyConfig[2], proxyConfig[3], "", "");
            singleClient.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)credentials);
            logger.info((Object)(String.valueOf(proxyConfig[0]) + "," + proxyConfig[1] + "," + proxyConfig[0] + "," + proxyConfig[2] + "," + proxyConfig[3]));
        }
        singleClient.getParams().setParameter("http.protocol.element-charset", (Object)(charset != null && charset.trim().length() > 0 ? charset : DEFAULT_ENCODING));
        singleClient.getParams().setParameter("http.protocol.content-charset", (Object)(charset != null && charset.trim().length() > 0 ? charset : DEFAULT_ENCODING));
        singleClient.getParams().setParameter("http.connection.timeout", (Object)(timeout > 0 ? timeout : CONNECT_TIME_OUT));
        singleClient.getParams().setParameter("http.socket.timeout", (Object)(timeout > 0 ? timeout : TIME_OUT));
        if (retry > 0) {
            ((DefaultHttpClient)client4Proxy).setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(retry, true));
        }
        return singleClient;
    }

    public static String readHtml4Get(String url, String[] proxyConfig) throws IOException {
        return Intf.readHtml4Get(url, proxyConfig, DEFAULT_ENCODING, TIME_OUT, RETRY_HANDLER_LIMIT);
    }

    public static String readHtml4Get(String url, String[] proxyConfig, String charset, int timeout, int retry) throws IOException {
        if (httpTemplate != null) {
            return httpTemplate.get(url, DEFAULT_REFERER_VALUE);
        }
        if (proxyConfig != null && proxyConfig.length != 4) {
            throw new IOException("proxy config error");
        }
        boolean isUseProxy = proxyConfig != null && proxyConfig.length == 4;
        Intf.genHttpClient(proxyConfig, timeout, retry);
        HttpGet method = new HttpGet(Intf.encodeGetUrl(url, charset));
        try {
            method.addHeader((Header)new BasicHeader(REFERER_KEY, DEFAULT_REFERER_VALUE));
            method.addHeader((Header)new BasicHeader("Host", method.getURI().getHost()));
            method.addHeader((Header)new BasicHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/29.0.1547.66 Safari/537.36"));
            logger.debug((Object)("readHtml4Get url: " + url));
            HttpResponse rsp = isUseProxy ? client4Proxy.execute((HttpUriRequest)method) : client.execute((HttpUriRequest)method);
            byte[] responseBody = IOUtils.toByteArray((InputStream)rsp.getEntity().getContent());
            String html = new String(responseBody, DEFAULT_ENCODING).replaceAll("\n\\s+", "\n").replaceFirst("^\\s+\n", "");
            if (rsp.getStatusLine().getStatusCode() != 200 && rsp.getStatusLine().getStatusCode() != 304) {
                throw new IOException("readHtml4Get error HttpStatus:" + rsp.getStatusLine().getStatusCode() + " " + rsp.getStatusLine().getReasonPhrase() + "\n from url:" + url + Intf.filterHtmlTag(html));
            }
            if (html.indexOf("Servlet Exception") != -1) {
                throw new IOException("readHtml4Get Servlet Exception:" + rsp.getStatusLine().getStatusCode() + " " + rsp.getStatusLine().getReasonPhrase() + "\n from url:" + url + Intf.filterHtmlTag(html));
            }
            String string = html;
            return string;
        }
        finally {
            method.abort();
        }
    }

    private static String encodeGetUrl(String url, String charset) {
        String tmpurl;
        String enurl = url;
        if (StringUtils.isNotBlank((String)url) && (tmpurl = url.trim()).indexOf("?") != -1 && tmpurl.indexOf(" ") != -1) {
            String[] ss = tmpurl.split("\\?");
            String uroot = ss[0];
            String parms = "";
            if (ss.length == 2) {
                String[] qpss;
                String[] stringArray = qpss = ss[1].split("&");
                int n = qpss.length;
                int n2 = 0;
                while (n2 < n) {
                    String p = stringArray[n2];
                    if (StringUtils.isNotBlank((String)p)) {
                        if (p.indexOf("=") != -1) {
                            String[] psss = p.split("=");
                            if (psss.length == 2 && StringUtils.isNotBlank((String)psss[1])) {
                                try {
                                    parms = String.valueOf(parms) + psss[0] + "=" + URLEncoder.encode(psss[1], charset) + "&";
                                }
                                catch (UnsupportedEncodingException unsupportedEncodingException) {}
                            }
                        } else {
                            try {
                                parms = String.valueOf(parms) + URLEncoder.encode(p, charset) + "&";
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                // empty catch block
                            }
                        }
                    }
                    ++n2;
                }
                enurl = (String.valueOf(uroot) + "?" + parms).replaceFirst("&$", "");
            }
        }
        logger.debug((Object)("encodeGetUrl url: " + enurl));
        return enurl;
    }

    public static String readHtml4Post(String url, String[] proxyConfig, Map params) throws IOException {
        return Intf.readHtml4Post(url, proxyConfig, params, DEFAULT_ENCODING, TIME_OUT, RETRY_HANDLER_LIMIT);
    }

    public static String readHtml4Post(String url, String[] proxyConfig, Map params, String charset, int timeout, int retry) throws IOException {
        if (proxyConfig != null && proxyConfig.length != 4) {
            throw new IOException("proxy config error");
        }
        boolean isUseProxy = proxyConfig != null && proxyConfig.length == 4;
        Intf.genHttpClient(proxyConfig, timeout, retry);
        HttpPost method = new HttpPost(url);
        try {
            method.addHeader((Header)new BasicHeader(REFERER_KEY, params != null ? Intf.stringValue((String)params.get(REFERER_KEY), DEFAULT_REFERER_VALUE) : DEFAULT_REFERER_VALUE));
            StringBuffer _sbposturl = new StringBuffer(url).append("?");
            UrlEncodedFormEntity entity = null;
            if (params != null) {
                ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
                params.remove(REFERER_KEY);
                for (String paramName : params.keySet()) {
                    String paramValue = null;
                    if (params.get(paramName) instanceof String[]) {
                        String[] pss = (String[])params.get(paramName);
                        int i = 0;
                        while (pss != null && i < pss.length) {
                            paramValue = pss[i];
                            _sbposturl.append(String.valueOf(paramName) + "=" + paramValue).append("&");
                            if (paramValue != null) {
                                pairs.add(new BasicNameValuePair(paramName, paramValue));
                            }
                            ++i;
                        }
                        continue;
                    }
                    paramValue = String.valueOf(params.get(paramName));
                    _sbposturl.append(String.valueOf(paramName) + "=" + paramValue).append("&");
                    if (paramValue == null) continue;
                    pairs.add(new BasicNameValuePair(paramName, paramValue));
                }
                entity = new UrlEncodedFormEntity(pairs, charset);
            }
            if (httpTemplate != null) {
                String string = (String)httpTemplate.post(url, null, null, entity);
                return string;
            }
            method.setEntity(entity);
            logger.debug((Object)("readHtml4Post url: " + _sbposturl.toString()));
            HttpResponse rsp = isUseProxy ? client4Proxy.execute((HttpUriRequest)method) : client.execute((HttpUriRequest)method);
            byte[] responseBody = IOUtils.toByteArray((InputStream)rsp.getEntity().getContent());
            String html = new String(responseBody, DEFAULT_ENCODING).replaceAll("\n\\s+", "\n").replaceFirst("^\\s+\n", "");
            if (rsp.getStatusLine().getStatusCode() != 200 && rsp.getStatusLine().getStatusCode() != 304) {
                throw new IOException("readHtml4Post error HttpStatus:" + rsp.getStatusLine().getStatusCode() + " " + rsp.getStatusLine().getReasonPhrase() + "\n from url:" + _sbposturl.toString() + "\n" + Intf.filterHtmlTag(html));
            }
            if (html.indexOf("Servlet Exception") != -1) {
                throw new IOException("readHtml4Post Servlet Exception:" + rsp.getStatusLine().getStatusCode() + " " + rsp.getStatusLine().getReasonPhrase() + "\n from url:" + _sbposturl.toString() + "\n" + Intf.filterHtmlTag(html));
            }
            String string = html;
            return string;
        }
        finally {
            method.abort();
        }
    }

    public static String uploadMultipartPost(String url, String[] proxyConfig, Map params, String charset, int timeout, int retry) throws IOException {
        if (proxyConfig != null && proxyConfig.length != 4) {
            throw new IOException("proxy config error");
        }
        HttpClient singleClient = Intf.genSingleHttpClient(proxyConfig, charset, timeout, retry);
        HttpPost method = null;
        try {
            method = new HttpPost(url);
            method.addHeader((Header)new BasicHeader(REFERER_KEY, params != null ? Intf.stringValue((String)params.get(REFERER_KEY), DEFAULT_REFERER_VALUE) : DEFAULT_REFERER_VALUE));
            StringBuffer _sbposturl = new StringBuffer(url).append("?");
            if (params != null) {
                params.remove(REFERER_KEY);
                MultipartEntity entity = new MultipartEntity();
                for (String paramName : params.keySet()) {
                    int n;
                    int n2;
                    Object[] objectArray;
                    Object paramValue = null;
                    if (params.get(paramName) instanceof String[]) {
                        String[] pss = (String[])params.get(paramName);
                        if (pss == null) continue;
                        objectArray = pss;
                        n2 = pss.length;
                        n = 0;
                        while (n < n2) {
                            Object ps;
                            paramValue = ps = objectArray[n];
                            _sbposturl.append(String.valueOf(paramName) + "=" + (String)paramValue).append("&");
                            if (paramValue != null) {
                                entity.addPart(new FormBodyPart(paramName, (ContentBody)new StringBody((String)paramValue)));
                            }
                            ++n;
                        }
                        continue;
                    }
                    if (params.get(paramName) instanceof File[]) {
                        File[] pff = (File[])params.get(paramName);
                        if (pff == null) continue;
                        objectArray = pff;
                        n2 = pff.length;
                        n = 0;
                        while (n < n2) {
                            Object pf = objectArray[n];
                            paramValue = ((File)pf).getName();
                            _sbposturl.append(String.valueOf(paramName) + "=" + (String)paramValue).append("&");
                            if (pf != null) {
                                entity.addPart(new FormBodyPart(paramName, (ContentBody)new FileBody((File)pf)));
                            }
                            ++n;
                        }
                        continue;
                    }
                    paramValue = String.valueOf(params.get(paramName));
                    _sbposturl.append(String.valueOf(paramName) + "=" + (String)paramValue).append("&");
                    if (paramValue == null) continue;
                    entity.addPart(new FormBodyPart(paramName, (ContentBody)new StringBody((String)paramValue)));
                }
                method.setEntity((HttpEntity)entity);
            }
            logger.debug((Object)("uploadMultipartPost url: " + _sbposturl.toString()));
            HttpResponse rsp = singleClient.execute((HttpUriRequest)method);
            byte[] responseBody = IOUtils.toByteArray((InputStream)rsp.getEntity().getContent());
            String html = new String(responseBody, DEFAULT_ENCODING).replaceAll("\n\\s+", "\n").replaceFirst("^\\s+\n", "");
            if (rsp.getStatusLine().getStatusCode() != 200 && rsp.getStatusLine().getStatusCode() != 304) {
                throw new IOException("uploadMultipartPost error HttpStatus:" + rsp.getStatusLine().getStatusCode() + " " + rsp.getStatusLine().getReasonPhrase() + "\n from url:" + _sbposturl.toString() + "\n" + Intf.filterHtmlTag(html));
            }
            if (html.indexOf("Servlet Exception") != -1) {
                throw new IOException("uploadMultipartPost Servlet Exception:" + rsp.getStatusLine().getStatusCode() + " " + rsp.getStatusLine().getReasonPhrase() + "\n from url:" + _sbposturl.toString() + "\n" + Intf.filterHtmlTag(html));
            }
            String string = html;
            return string;
        }
        finally {
            method.abort();
        }
    }

    private static String filterHtmlTag(String text) {
        if (text == null) {
            return "";
        }
        Matcher m = Pattern.compile("(?i)<pre\\s*>([\\s\\S]*?)</pre\\s*>").matcher(text);
        if (m.find(0)) {
            text = text.replaceAll("(?si).*<pre\\s*>([\\s\\S]*?)</pre\\s*>.*", "$1");
        }
        text = text.replaceAll("(?si)<\\s*\\bscript\\b(.*?)>(.*?)</script>", "").replaceAll("(?si)<\\s*\\bstyle\\b(.*?)>(.*?)</style>", "").replaceAll("(?s)<\\s*[\\w|/][^>]*>", "").replaceAll("<\\!DOCTYPE\\s+[^>]*>", "").replaceAll("&nbsp;", " ").replaceAll("\n\\s+", "\n").replaceFirst("^\\s+\n", "");
        return text;
    }

    public static String stringValue(String v, String def) {
        if (v == null || v.trim().length() == 0) {
            return def;
        }
        return v.trim();
    }
}

