package cn.pconline.search.common.log;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

/**
 * 搜索日志迭代器
 * 
 * @author zengjie
 * @since 2013-9-23
 * @see Iterator
 * @see Closeable
 */
public class LogIterator implements Iterator<SearchLog>, Closeable
{

    private InputStream in;

    private Iterator<SearchLog> targetIterator;

    LogIterator(InputStream in, Iterator<SearchLog> targetIterator)
    {
        super();
        this.in = in;
        this.targetIterator = targetIterator;
    }

    @Override
    public void close() throws IOException
    {
        in.close();
    }

    @Override
    public boolean hasNext()
    {
        return targetIterator.hasNext();
    }

    @Override
    public SearchLog next()
    {
        return targetIterator.next();
    }

    /**
     * {@inheritDoc}
     * 
     * @throws UnsupportedOperationException
     *             this operation is unsupported by this iterator
     */
    @Override
    public void remove()
    {
        throw new UnsupportedOperationException();
    }

}
