package cn.pconline.search.common.log;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import cn.pconline.search.common.log.GroupCounter.Item;

/**
 * 日志信息提取帮助类
 * 
 * @author zengjie
 * @since 2013-9-23
 * @see
 */
public class SearchLogHelper
{

    @SuppressWarnings("unchecked")
    public static List<Item> getTop(LogIO logIO, int top,
            Map<SearchLog, Integer> keyOccurMap) throws Exception
    {
        GroupCounter groupCounter = getGroupCounter(logIO, keyOccurMap);
        if (groupCounter == null)
        {
            return Collections.EMPTY_LIST;
        }
        return groupCounter.getTop(top);
    }

    public static GroupCounter getGroupCounter(LogIO logIO,
            Map<SearchLog, Integer> keyOccurMap) throws Exception
    {
        LogIterator iterator = logIO.getYesterdayLogs();
        GroupCounter groupCounter = null;
        if (iterator != null)
        {
            groupCounter = new GroupCounter();
            while (iterator.hasNext())
            {
                if (Thread.currentThread().isInterrupted())
                {
                    throw new InterruptedException();
                }
                SearchLog searchLog = iterator.next();

                Integer result = keyOccurMap.get(searchLog);
                if (result == null)
                {
                    // 得到最后搜索结果数,如果是负数,则设为0,负数不能覆盖正数和0
                    keyOccurMap.put(searchLog, searchLog.getRetCount());
                }
                else if (searchLog.getRetCount() >= 0)
                {
                    // 当在OScache缓存中存在时,返回的结果是-1或者任意负数
                    keyOccurMap.put(searchLog, searchLog.getRetCount());// 得到最后搜索结果数,多个关键字的,后面覆盖前面的
                }
                groupCounter.add(searchLog);
            }
            iterator.close();
        }
        return groupCounter;
    }

}
