package cn.pconline.search.common.query;

import org.apache.commons.lang.ArrayUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.common.params.CommonParams;
import org.apache.solr.common.params.HighlightParams;

/**
 * 扩展solrj的SolrQuery对象，添加了一部分方法
 * 
 * @author zengjie
 * @since 2013-9-24
 * @see SolrQuery
 */
public class SolrQueryExt extends SolrQuery
{

    private static final long serialVersionUID = 2713307384547708781L;

    public SolrQueryExt()
    {
        super();
    }

    public SolrQueryExt(String q)
    {
        super(q);
    }

    /**
     * 设置指定高亮字段如果没有匹配词，则直接返回原来的值<br>
     * <i>要使该参数有效，先设置 {@link SolrQuery#setHighlight(boolean)} </i>
     * 
     * @param field
     */
    public SolrQueryExt setHighLightAlternateField(String... fields)
    {
        if (ArrayUtils.isNotEmpty(fields))
        {
            for (String field : fields)
            {
                set(fpname(field, HighlightParams.ALTERNATE_FIELD), field);
            }
        }
        return this;
    }

    /**
     * 设置指定字段返回原来的值的长度 <br>
     * <i>要使该参数有效，先设置 {@link SolrQuery#setHighlight(boolean)} </i>
     * 
     * @param field
     * @param length
     * @see SolrQueryExt#setHighLightAlternateField(String)
     */
    public SolrQueryExt setHighLightAlternateFieldLength(String field,
            int length)
    {
        if (length <= 0)
        {
            throw new IllegalArgumentException("length");
        }
        set(fpname(field, HighlightParams.ALTERNATE_FIELD_LENGTH), length);
        return this;
    }

    /**
     * 设置通过functionquery来进行排序操作
     * 
     * @param q
     * @param order
     * @return
     * @see SolrQuery#addSortField(String, ORDER)
     */
    public SolrQueryExt addFunctionQuerySort(FunctionQuery q, ORDER order)
    {
        this.addSortField(q.toString(), order);
        return this;
    }

    /**
     * 如果是使用edismax或者dismax查询时请通过 {@link SolrQuery#setQuery(String)}来设置查询
     * 
     * @param query
     */
    public SolrQueryExt setQuery(Q query)
    {
        set(CommonParams.Q, query.toString());
        return this;
    }

    /**
     * 设置是否开启近义词扩展查询
     * 
     * @param useSynonym
     * @return
     */
    public SolrQueryExt setUseSynonym(boolean useSynonym)
    {
        set("useSynonym", useSynonym);
        return this;
    }

    /**
     * 添加需要前置显示的广告ID
     * 
     * @param ids
     * @return
     */
    public SolrQueryExt addIncludeAdIds(String... ids)
    {
        if (ArrayUtils.isEmpty(ids))
        {
            return this;
        }
        String inludes = get("elevateIncludes");
        StringBuilder sb = null;
        if (inludes != null)
        {
            sb = new StringBuilder();
        }
        else
        {
            sb = new StringBuilder(",");
        }
        for (String id : ids)
        {
            sb.append(id).append(",");
        }
        sb.delete(sb.length() - 1, sb.length());
        set("elevateIncludes", sb.toString());
        return this;
    }

    /**
     * 设置分词默认连接操作符
     * 
     * @see Ope
     * @param operator
     * @return
     */
    public SolrQueryExt setDefaultOperator(Ope operator)
    {
        set("q.op", operator.toString());
        return this;
    }

    /**
     * solr查询操作符
     * 
     * @author zengjie
     * @since 2013-10-31
     * @see
     */
    public static enum Ope
    {
        AND, OR
    }

}
