package cn.pconline.search.common.tools.semantic2;

import java.util.List;

import org.apache.commons.collections.CollectionUtils;

/**
 * 表示一个语义分析结果
 * 
 * @author zengjie
 * @since 2013-9-17
 * @see SemanticAnalyzer
 */
public class SemanticResult
{

    private List<SemanticWord> words;

    private String otherQuery;

    public SemanticResult()
    {
    }

    public SemanticResult(List<SemanticWord> words, String otherQuery)
    {
        super();
        this.words = words;
        this.otherQuery = otherQuery;
    }

    public List<SemanticWord> getWords()
    {
        return words;
    }

    public void setWords(List<SemanticWord> words)
    {
        this.words = words;
    }

    public String getOtherQuery()
    {
        return otherQuery;
    }

    public void setOtherQuery(String otherQuery)
    {
        this.otherQuery = otherQuery;
    }

    /**
     * 当前语义分析结果是否包含语义信息
     * 
     * @return
     */
    public boolean hasSemantic()
    {
        return CollectionUtils.isNotEmpty(words);
    }

    @Override
    public String toString()
    {
        return "SemanticResult [words=" + words + ", otherQuery=" + otherQuery
                + "]";
    }

}
