package cn.pconline.search.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.apache.log4j.Logger;

/**
 * 每日固定时间运行线程
 * 
 * @author zengjie
 * @since 2013-9-27
 * @see
 */
public class DaliyFixTimeRunThread extends Thread
{

    private static Logger logger = Logger
            .getLogger(DaliyFixTimeRunThread.class);

    private static final int MS_OF_DAY = 24 * 60 * 60 * 1000;

    private Date runTime;

    private Runnable runnable;

    private volatile boolean onlyRunOnce;

    public DaliyFixTimeRunThread(String runTime, String threadName)
    {
        super(threadName);
        this.runTime = getTimeByExp(runTime);
    }

    public DaliyFixTimeRunThread(String runTime, Runnable runnable)
    {
        this.runTime = getTimeByExp(runTime);
        this.runnable = runnable;
    }

    private Date getTimeByExp(String time)
    {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (time == null)
        {
            time = sdf.format(new Date());
        }
        Date ret = null;
        try
        {
            ret = sdf.parse(time);
        }
        catch (ParseException e)
        {
        }
        if (ret == null)
        {
            sdf = new SimpleDateFormat("HH:mm:ss");
            try
            {
                ret = sdf.parse(time);
            }
            catch (ParseException e)
            {
                ret = new Date();
            }
        }
        return ret;
    }

    public final void run()
    {
        while (true)
        {
            try
            {
                sleepToRun();
            }
            catch (InterruptedException e)
            {
                return;
            }
            if (runnable != null)
            {
                runnable.run();
            }
            doRun();
            if (onlyRunOnce)
            {
                return;
            }
        }

    }

    /**
     * 休眠指定时间，确保每天只运行一次
     * 
     * @throws InterruptedException
     */
    private synchronized void sleepToRun() throws InterruptedException
    {
        try
        {
            Date now = new Date();
            while (runTime.getTime() < now.getTime())
            {
                runTime.setTime(runTime.getTime() + MS_OF_DAY);
            }
            long timeToSpleep = (runTime.getTime() - now.getTime());
            logger.debug("Sleep " + timeToSpleep + " ms to run");
            Thread.sleep(timeToSpleep);
            runTime.setTime(runTime.getTime() + MS_OF_DAY);
        }
        catch (InterruptedException e)
        {
            logger.error("sleep interrupted", e);
            throw e;
        }
    }

    /**
     * 每日运行线程实际执行代码
     */
    protected void doRun()
    {

    }

    public void setOnlyRunOnce(boolean onlyRunOnce)
    {
        this.onlyRunOnce = onlyRunOnce;
    }

    public static void main(String[] args)
    {
        new DaliyFixTimeRunThread("", "");
    }
}
