package cn.pconline.search.common.tools.sensitive;

import org.apache.log4j.Logger;

import cn.pconline.search.common.tools.sensitive.AnalyzeSensitiveFilter.WordMapping;

/**
 * 敏感词匹配器实现
 * 
 * @author zengjie
 * @since 2013-9-29
 * @see
 */
class SensitiveMatcherImpl implements SensitiveMatcher
{

    private static Logger logger = Logger.getLogger(SensitiveMatcherImpl.class);

    private WordMapping mapping;

    private String input;

    private int testLength;

    private int testOffset;

    private int maxInc = -1;

    private SensitiveWord currentWord = null;

    private int currentStart = 0;

    private int currentEnd = 0;

    public SensitiveMatcherImpl(WordMapping mapping, String input)
    {
        this.mapping = mapping;
        this.input = input;
        this.testLength = mapping.getMinWordLen();
    }

    @Override
    public boolean find()
    {
        if (maxInc < 0)
        {
            if (testLength > mapping.getMaxWordLen())
            {
                setEndState();
                return false;
            }
            if (testLength > input.length())
            {
                setEndState();
                return false;
            }
            testOffset = 0;
            maxInc = input.length() - testLength;
        }
        String test = input.substring(testOffset, testLength + testOffset);
        if ((currentWord = mapping.hasWord(test)) != null)
        {
            currentStart = testOffset;
            currentEnd = testOffset + testLength;
            if (logger.isDebugEnabled())
            {
                logger.debug("Find a sensitive word [" + test + "] in " + input);
            }
            addAndcheckTestOffset();
            return true;
        }
        addAndcheckTestOffset();
        return find();
    }

    /**
     * 增长并且检查偏移量是否到最大偏移量
     */
    private void addAndcheckTestOffset()
    {
        testOffset++;
        if (testOffset > maxInc)
        {
            maxInc = -1;
            testLength++;
        }
    }

    @Override
    public int getStart()
    {
        return currentStart;
    }

    @Override
    public int getEnd()
    {
        return currentEnd;
    }

    @Override
    public String getMatch()
    {
        if (currentWord != null)
        {
            return currentWord.getWord();
        }
        return null;
    }

    @Override
    public int getStable()
    {
        if (currentWord != null)
        {
            return currentWord.getStable();
        }
        return -1;
    }

    private void setEndState()
    {
        currentEnd = -1;
        currentStart = -1;
        currentWord = null;
    }

    @Override
    public String toString()
    {
        return "MatcherInfo [input=" + input + ", matchWord=" + currentWord
                + ", matchStart=" + currentStart + ", matchEnd=" + currentEnd
                + "]";
    }

    // private void init()
    // {
    // i = minLength;
    // for (int i = minWord; i <= maxWord; i++)
    // {
    // if (i > input.length())
    // {
    // return SensitiveMatcher.EMPTY_MATCHER;
    // }
    // int maxInc = input.length() - i;
    // for (int j = 0; j <= maxInc; j++)
    // {
    // if (words.contains(test = input.substring(j, i + j)))
    // {
    // if (logger.isDebugEnabled())
    // {
    // logger.debug("Find a sensitive word [" + test
    // + "] in " + input);
    // }
    // return true;
    // }
    // }
    // }
    // }

}