package cn.pconline.search.common.util;

import java.util.BitSet;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

/**
 * 
 * <p>
 * Title:Cache
 * </p>
 * <p>
 * Description:封装了同步操作的缓存
 * </p>
 * 
 * @author kelly 2009-6-24 jiajiam2000@hotmail.com
 */
public class Cache
{

    private Map lhm;

    private int maxSize;

    /**
     * 缓存版本号
     */
    private AtomicLong version = new AtomicLong(0);

    public void setVersion(long version)
    {
        this.version.set(version);
    }

    public long getVersion()
    {
        return version.get();
    }

    @SuppressWarnings("unchecked")
    public Cache(int size)
    {
        lhm = (Map<String, BitSet>) Collections
                .synchronizedMap(new LRULinkedHashMap(size));
        this.maxSize = size;
    }

    public void clear()
    {
        lhm.clear();
    }

    @SuppressWarnings("unchecked")
    public void add(String key, Object value)
    {
        if (key != null && key.trim().length() > 0 && value != null)
        {
            lhm.put(key, value);

        }

    }

    public Object get(String key)
    {
        return lhm.get(key);

    }

    public int size()
    {
        return lhm.size();
    }

    public int getMaxSize()
    {
        return maxSize;
    }
}
