package cn.pconline.search.common.util;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.commons.lang.StringUtils;

public class QueryUtil
{

    /**
     * 根据指定关键字和权值Map转换成solr内嵌edismax查询
     * 
     * @param keyword
     * @param boostMap
     * @return
     */
    public static String toDismaxQuery(String keyword,
            Map<String, Float> boostMap)
    {
        StringBuilder builder = new StringBuilder();
        builder.append("_query_:\"{!edismax qf='");
        for (Entry<String, Float> en : boostMap.entrySet())
        {
            builder.append(en.getKey()).append("^")
                    .append(new BigDecimal(en.getValue()).toPlainString())
                    .append(" ");
        }
        builder.append("'}").append(escapeQStr(keyword));
        return builder.toString();
    }

    /**
     * 转义查询中的特殊字符串
     * 
     * @param query
     * @return
     */
    public static String escapeQStr(String query)
    {
        if (StringUtils.isEmpty(query))
        {
            return query;
        }
        query = query.trim();
        query = query.replace("\"", "\\\"");
        query = query.replace("+", "\\+");
        query = query.replace("-", "\\-");
        query = query.replace("(", "\\(");
        query = query.replace(")", "\\)");
        query = query.replace("^", "\\^");
        query = query.replace("OR", "\\OR");
        query = query.replace("AND", "\\AND");
        query = query.replace("NOT", "\\NOT");
        return query;
    }

}
