package cn.pconline.search.common.taglib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.servlet.jsp.JspException;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import cn.pconline.search.common.SearchFrame;
import cn.pconline.search.common.SolrSearcher;
import cn.pconline.search.common.ks.KSResult;
import cn.pconline.search.common.util.HttpUrl;

public class NoResultTag extends BaseTag
{

    private SolrSearcher searcher;

    private String appName;

    private String keyword;

    private String var;

    private String index = "SearchedKeyword";

    private String host;

    private Integer suggestCount;

    private HttpUrl baseUrl;

    private Iterator<Map<String, Object>> suggestList;

    private List<String> list;

    private static final long serialVersionUID = 539243727621427688L;

    public void setSearcher(SolrSearcher searcher)
    {
        this.searcher = searcher;
    }

    public void setAppName(String appName)
    {
        this.appName = appName;
    }

    public void setKeyword(String keyword)
    {
        this.keyword = keyword;
    }

    @Override
    public int doStartTag() throws JspException
    {
        if (StringUtils.isBlank(keyword))
        {
            return SKIP_BODY;
        }
        // 初始化变量
        if (StringUtils.isBlank(var))
        {
            var = "suggest";
        }
        keyword = keyword.trim();

        String _q = "domain:("
                + (keyword.replaceAll("　", " ").replaceAll("", " ")
                        .replaceAll("\\s+", " ").trim().replaceAll(" ", " OR "))
                + ")";

        String indexName = "APP:(zh)";

        if (appName != null && appName.trim().length() > 0)
        {
            indexName = "APP:(" + appName + ")";
        }

        _q = indexName + " AND  " + _q;

        int _pageSize = (suggestCount == null || suggestCount.intValue() <= 0) ? 20
                : suggestCount;// 要取的数目

        list = new ArrayList<String>();

        String retStr = SearchFrame.get().getHomonynsWords(keyword);

        list.addAll(Arrays.asList(retStr.split(";")));
        list.remove("");
        list.remove(keyword);
        HttpUrl holder = new HttpUrl();
        holder.setHostAndPort(host);
        holder.setRequestUri("search.jsp");
        holder.replaceParam("appName", index);
        holder.replaceParam("return", "url,keyword");
        holder.replaceParam("pageNo", 1);
        holder.replaceParam("perPage", _pageSize);
        holder.replaceParam("q", _q);
        if (searcher == null)
        {
            searcher = SearchFrame.get().getSearcher();
        }
        KSResult result = null;
        try
        {
            result = searcher.searchKs(holder);
        }
        catch (IOException e)
        {
            throw new JspException(e);
        }
        if (CollectionUtils.isEmpty(result.getDocuments()))
        {
            return SKIP_BODY;
        }
        suggestList = result.getDocuments().iterator();
        Map<String, Object> doc = getDoc();
        if (doc == null)
        {
            return SKIP_BODY;
        }
        pageContext.setAttribute(var, doc);
        return EVAL_BODY_INCLUDE;
    }

    @Override
    public int doAfterBody() throws JspException
    {
        Map<String, Object> doc = getDoc();
        if (doc == null)
        {
            return EVAL_PAGE;
        }
        pageContext.setAttribute(var, doc);
        return EVAL_BODY_AGAIN;
    }

    private Map<String, Object> getDoc()
    {
        while (true)
        {
            if (suggestList == null || !suggestList.hasNext())
            {
                return null;
            }
            Map<String, Object> tdoc = suggestList.next();

            if (tdoc != null && tdoc.get("url") != null)
            {
                String url = ((String) tdoc.get("url")).toLowerCase()
                        .replaceAll("　| ", "");
                baseUrl.replaceParam("q", url);
                tdoc.put("url", baseUrl.toString());
                if ((!url.equalsIgnoreCase(keyword)) && !list.contains(url))
                {
                    list.add((String) tdoc.get("keyword"));
                }
                else
                {
                    continue;
                }
            }
            else
            {
                continue;
            }
            return tdoc;
        }
    }

    public void setVar(String var)
    {
        this.var = var;
    }

    public void setIndex(String index)
    {
        this.index = index;
    }

    public void setSuggestCount(Integer suggestCount)
    {
        this.suggestCount = suggestCount;
    }

    public void setBaseUrl(String baseUrl)
    {
        this.baseUrl = HttpUrl.fromUrl(baseUrl, null);
    }

    public void setBaseUrl(HttpUrl baseUrl)
    {
        this.baseUrl = baseUrl;
    }

    public void setHost(String host)
    {
        this.host = host;
    }

}
