package cn.pconline.search.common.tools.sensitive;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.lang.StringUtils;

public class OracleSensitiveWordSource implements SensitiveWordSource
{

    private Connection dbConn;

    private boolean loaded;

    private Iterator<SensitiveWord> iterator;

    private String domain;

    public OracleSensitiveWordSource(String connStr, String domain)
    {
        initConnection(connStr);
        this.domain = domain;
    }

    @Override
    public SensitiveWord nextWord()
    {
        if (!loaded)
        {
            load();
            loaded = true;
        }
        if (iterator == null || !iterator.hasNext())
        {
            return null;
        }
        return iterator.next();
    }

    private void load()
    {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try
        {
            ps = dbConn
                    .prepareStatement("select k.term,l.levelid from csr_keyword k,csr_keyword_level l where k.keywordId = l.keywordId and l.domain = ? "
                            + "and (k.expiryAt is null or k.expiryAt is not null and  round(to_number(sysdate-k.expiryAt)*24*60*60)<0) and (l.levelid=1 or l.levelid=2) ");
            ps.setString(1, domain);
            rs = ps.executeQuery();
            List<SensitiveWord> list = new ArrayList<SensitiveWord>();
            String kw = null;
            while (rs.next())
            {
                kw = rs.getString("term");
                if (StringUtils.isBlank(kw))
                {
                    continue;
                }
                list.add(new SensitiveWord(kw, rs.getInt("levelid")));
            }
            iterator = list.iterator();
        }
        catch (SQLException e)
        {
            throw new RuntimeException(e);
        }
        finally
        {
            try
            {
                if (ps != null)
                {
                    ps.close();
                }
            }
            catch (Exception e)
            {
            }
            try
            {
                if (rs != null)
                {
                    rs.close();
                }
            }
            catch (Exception e)
            {
            }
        }
    }

    private void initConnection(String connStr)
    {
        try
        {
            Class.forName("oracle.jdbc.driver.OracleDriver");
            dbConn = DriverManager.getConnection(connStr);
        }
        catch (ClassNotFoundException e)
        {
            throw new RuntimeException(e);
        }
        catch (SQLException e)
        {
            throw new RuntimeException(e);
        }
    }

    public void close()
    {
        try
        {
            dbConn.close();
        }
        catch (Exception e)
        {
        }
    }
}