package cn.pconline.search.common.tools.sensitive;

public interface SensitiveMatcher
{

    /**
     * 先调用此方看查看是否有匹配到敏感词
     * 
     * @return
     */
    public boolean find();

    /**
     * 获取当前匹配的开始下标
     * 
     * @return
     */
    public int getStart();

    /**
     * 获取当前匹配的结束下标
     * 
     * @return
     */
    public int getEnd();

    /**
     * 获取当前匹配的敏感词
     * 
     * @return
     */
    public String getMatch();

    /**
     * 获取当前敏感词级别
     * 
     * @return
     */
    public int getStable();

    /**
     * 空匹配
     */
    public static final SensitiveMatcher EMPTY_MATCHER = new SensitiveMatcher()
    {

        @Override
        public int getStart()
        {
            throw new IllegalStateException("has no more sensitive word match");
        }

        @Override
        public int getStable()
        {
            throw new IllegalStateException("has no more sensitive word match");
        }

        @Override
        public String getMatch()
        {
            throw new IllegalStateException("has no more sensitive word match");
        }

        @Override
        public int getEnd()
        {
            throw new IllegalStateException("has no more sensitive word match");
        }

        @Override
        public boolean find()
        {
            return false;
        }
    };
}
