package cn.pconline.search.common.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;

/**
 * 对HttpServlet的属性封装
 * 
 * @author zengjie
 * @since 2013-11-20
 * @see javax.servlet.http.HttpServletRequestWrapper
 */
public class HttpServletRequestWrapper extends
        javax.servlet.http.HttpServletRequestWrapper
{

    private Map<String, Object> attributeMap = new HashMap<String, Object>();

    private Set<String> deleteKeyList = new HashSet<String>();

    public HttpServletRequestWrapper(HttpServletRequest request)
    {
        super(request);
    }

    /**
     * 将所有的属性操作应用到目标Request对象
     */
    public void applyAttributes()
    {
        // ServletRequest target = getRequest();
        if (deleteKeyList.size() > 0)
        {
            for (String key : deleteKeyList)
            {
                super.removeAttribute(key);
            }
        }
        if (attributeMap.size() > 0)
        {
            for (Entry<String, Object> e : attributeMap.entrySet())
            {
                super.setAttribute(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public void setAttribute(String name, Object o)
    {
        if (o == null)
        {
            this.removeAttribute(name);
        }
        else
        {
            deleteKeyList.remove(name);
            attributeMap.put(name, o);
        }
    }

    @Override
    public void removeAttribute(String name)
    {
        this.attributeMap.remove(name);
        deleteKeyList.add(name);
    }

}
