/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.tools.segment;

import cn.pconline.search.common.tools.segment.SegGraph;
import cn.pconline.search.common.tools.segment.bean.ContextStat;
import cn.pconline.search.common.tools.segment.bean.Dictionary;
import cn.pconline.search.common.tools.segment.bean.POS;
import cn.pconline.search.common.tools.segment.bean.SegNode;
import cn.pconline.search.common.tools.segment.bean.WordItem;
import cn.pconline.search.common.tools.segment.utility.Utility;
import java.io.IOException;
import java.util.ArrayList;

public class PosTagger {
    private Dictionary coreDict;
    private Dictionary unknownDict;
    private ContextStat context;
    private int pos;
    private Utility.TAG_TYPE tagType;
    String unknownFlags;

    public PosTagger(Utility.TAG_TYPE type, String fileName, Dictionary coreDict) throws IOException {
        if (fileName != null) {
            this.coreDict = coreDict;
            if (type == Utility.TAG_TYPE.TT_NORMAL) {
                this.unknownDict = coreDict;
            } else {
                this.unknownDict = new Dictionary();
                this.unknownDict.load(fileName + ".dct");
            }
            this.context = new ContextStat();
            this.context.load(fileName + ".ctx");
            this.tagType = type;
            switch (type) {
                case TT_PERSON: 
                case TT_TRANS_PERSON: {
                    this.pos = -28274;
                    this.unknownFlags = "\u672a##\u4eba";
                    break;
                }
                case TT_PLACE: {
                    this.pos = -28275;
                    this.unknownFlags = "\u672a##\u5730";
                    break;
                }
                default: {
                    this.pos = 0;
                }
            }
        }
    }

    public boolean recognition(SegGraph segGraph, ArrayList<SegNode> sns) {
        if (segGraph != null && sns != null && this.coreDict != null && this.unknownDict != null && this.context != null) {
            this.posTag(sns);
            this.getBestPos(sns);
            switch (this.tagType) {
                case TT_PERSON: {
                    this.personRecognize(segGraph, sns);
                    break;
                }
                case TT_TRANS_PERSON: 
                case TT_PLACE: {
                    this.placeRecognize(segGraph, sns, this.coreDict);
                }
            }
        }
        return true;
    }

    public boolean recognition(ArrayList<SegNode> sns) {
        if (sns != null && this.unknownDict != null && this.context != null) {
            this.posTag(sns);
            this.getBestPos(sns);
            switch (this.tagType) {
                case TT_NORMAL: {
                    for (SegNode sn : sns) {
                        if (sn.getPos() != 0) continue;
                        sn.setPos(this.getBestTag(sn));
                    }
                    break;
                }
            }
        }
        return true;
    }

    public void posTag(ArrayList<SegNode> sns) {
        block15: {
            int i;
            if (sns == null || this.coreDict == null || this.unknownDict == null || this.context == null) break block15;
            String curWord = null;
            for (i = 0; i < sns.size(); ++i) {
                SegNode sn;
                block18: {
                    block16: {
                        ArrayList<WordItem> wis;
                        block19: {
                            block17: {
                                String prevWord;
                                sn = sns.get(i);
                                sn.setAllPos(null);
                                curWord = sn.getSrcWord();
                                if (this.tagType == Utility.TAG_TYPE.TT_NORMAL) break block16;
                                if (this.tagType == Utility.TAG_TYPE.TT_TRANS_PERSON && i > 0 && Utility.charType(prevWord = sns.get(i - 1).getSrcWord()) == 7) {
                                    if (".".equals(curWord)) {
                                        curWord = "\uff0e";
                                    } else if ("-".equals(curWord)) {
                                        curWord = "\uff0d";
                                    }
                                }
                                wis = this.unknownDict.getHandle(curWord);
                                for (int j = 0; wis != null && j < wis.size(); ++j) {
                                    WordItem wi = wis.get(j);
                                    int tag = wi.getHandle();
                                    double freq = -Math.log(1 + wi.getFreq());
                                    POS pos = new POS(tag, freq += Math.log(this.context.getFreq(0, wi.getHandle()) + wis.size() + 1));
                                    sn.addPos(pos);
                                }
                                if (!"\u59cb##\u59cb".equals(curWord)) break block17;
                                sn.addPos(new POS(100, 0.0));
                                break block18;
                            }
                            if (!"\u672b##\u672b".equals(curWord)) break block19;
                            sn.addPos(new POS(101, 0.0));
                            break block18;
                        }
                        int nFreq = 0;
                        wis = this.coreDict.getHandle(curWord);
                        if (wis == null) break block18;
                        for (WordItem wi : wis) {
                            nFreq += wi.getFreq();
                        }
                        if (wis.size() <= 0) break block18;
                        double freq = -Math.log(1 + nFreq);
                        sn.addPos(new POS(0, freq += Math.log(this.context.getFreq(0, 0) + wis.size())));
                        break block18;
                    }
                    if (sn.getPos() > 0) {
                        int tag = sn.getPos();
                        double value = -Math.log(sn.getValue());
                        if ((value += Math.log(this.context.getFreq(0, tag))) < 0.0) {
                            value = 0.0;
                        }
                        sn.addPos(new POS(tag, value));
                    } else {
                        ArrayList<WordItem> wis;
                        if (sn.getPos() < 0) {
                            sn.setPos(-sn.getPos());
                            sn.addPos(new POS(-sn.getPos(), sn.getValue()));
                        }
                        if ((wis = this.coreDict.getHandle(curWord)) != null) {
                            for (WordItem wi : wis) {
                                int tag = wi.getHandle();
                                double value = -Math.log(1 + wi.getFreq());
                                sn.addPos(new POS(tag, value += Math.log(this.context.getFreq(0, tag) + wis.size())));
                            }
                        }
                    }
                }
                if (sn.getAllPos() == null) {
                    this.guessPos(this.tagType, sn);
                }
                if (i - 1 < 0 || sns.get(i - 1).getPosSize() != -1 || sn.getPosSize() <= 0) continue;
                POS pos = new POS(sn.getAllPos().get(0).getTag(), 0.0);
                sns.get(i - 1).addPos(pos);
            }
            SegNode last = sns.get(i - 1);
            if (last != null) {
                SegNode sn = new SegNode();
                int tag = 0;
                tag = this.tagType != Utility.TAG_TYPE.TT_NORMAL ? 101 : 1;
                POS pos = new POS(tag, 0.0);
                sn.addPos(pos);
                sns.add(sn);
            }
        }
    }

    private void getBestPos(ArrayList<SegNode> sns) {
        ArrayList<POS> prevAllPos = null;
        ArrayList<POS> allPos = null;
        if (sns != null && this.context != null) {
            for (int i = 0; i < sns.size(); ++i) {
                if (i == 0) {
                    int pos = this.tagType != Utility.TAG_TYPE.TT_NORMAL ? 100 : 0;
                    prevAllPos = new ArrayList();
                    prevAllPos.add(new POS(pos, 0.0));
                } else {
                    prevAllPos = sns.get(i - 1).getAllPos();
                }
                allPos = sns.get(i).getAllPos();
                if (allPos == null) continue;
                for (POS pos : allPos) {
                    int minPrev = 0;
                    double minFreq = 1000.0;
                    for (int k = 0; prevAllPos != null && k < prevAllPos.size(); ++k) {
                        POS prevPos = prevAllPos.get(k);
                        double temp = this.context.getPossibility(0, prevPos.getTag(), pos.getTag());
                        if (!((temp = -Math.log(temp) + prevPos.getFreq()) < minFreq)) continue;
                        minFreq = temp;
                        minPrev = k;
                    }
                    pos.setPrev(minPrev);
                    pos.setFreq(pos.getFreq() + minFreq);
                }
            }
            this.tagBest(sns);
        }
    }

    private int guessPos(Utility.TAG_TYPE tagType, SegNode sn) {
        int result = -1;
        if (sn != null && this.context != null) {
            String word = sn.getWord();
            double freq = 0.0;
            switch (tagType) {
                case TT_NORMAL: {
                    break;
                }
                case TT_PERSON: {
                    if (word.indexOf("\u00d7\u00d7") != -1) {
                        freq = 1.0 / (double)(this.context.getFreq(0, 6) + 1);
                        sn.addPos(new POS(6, freq));
                        break;
                    }
                    freq = 1.0 / (double)(this.context.getFreq(0, 0) + 1);
                    sn.addPos(new POS(0, freq));
                    if (sn.getLen() >= 4) {
                        freq = 1.0 / (double)(this.context.getFreq(0, 0) + 1);
                        sn.addPos(new POS(0, freq));
                        freq = 1.0 / (double)(this.context.getFreq(0, 11) * 8);
                        sn.addPos(new POS(11, freq));
                        freq = 1.0 / (double)(this.context.getFreq(0, 12) * 8);
                        sn.addPos(new POS(12, freq));
                        freq = 1.0 / (double)(this.context.getFreq(0, 13) * 8);
                        sn.addPos(new POS(13, freq));
                        break;
                    }
                    if (sn.getLen() != 2) break;
                    freq = 1.0 / (double)(this.context.getFreq(0, 0) + 1);
                    sn.addPos(new POS(0, freq));
                    int charType = Utility.charType(word);
                    if (charType == 17 || charType == 7) {
                        freq = 1.0 / (double)(this.context.getFreq(0, 1) + 1);
                        sn.addPos(new POS(1, freq));
                        freq = 1.0 / (double)(this.context.getFreq(0, 2) + 1);
                        sn.addPos(new POS(2, freq));
                        freq = 1.0 / (double)(this.context.getFreq(0, 3) + 1);
                        sn.addPos(new POS(3, freq));
                        freq = 1.0 / (double)(this.context.getFreq(0, 4) + 1);
                        sn.addPos(new POS(4, freq));
                    }
                    freq = 1.0 / (double)(this.context.getFreq(0, 11) * 8);
                    sn.addPos(new POS(11, freq));
                    freq = 1.0 / (double)(this.context.getFreq(0, 12) * 8);
                    sn.addPos(new POS(12, freq));
                    freq = 1.0 / (double)(this.context.getFreq(0, 13) * 8);
                    sn.addPos(new POS(13, freq));
                    break;
                }
                case TT_PLACE: {
                    freq = 1.0 / (double)(this.context.getFreq(0, 0) + 1);
                    sn.addPos(new POS(0, freq));
                    if (sn.getLen() >= 4) {
                        freq = 1.0 / (double)(this.context.getFreq(0, 11) * 8);
                        sn.addPos(new POS(11, freq));
                        freq = 1.0 / (double)(this.context.getFreq(0, 12) * 8);
                        sn.addPos(new POS(12, freq));
                        freq = 1.0 / (double)(this.context.getFreq(0, 13) * 8);
                        sn.addPos(new POS(13, freq));
                        break;
                    }
                    if (sn.getLen() != 2) break;
                    freq = 1.0 / (double)(this.context.getFreq(0, 0) + 1);
                    sn.addPos(new POS(0, freq));
                    int charType = Utility.charType(word);
                    if (charType == 17 || charType == 7) {
                        freq = 1.0 / (double)(this.context.getFreq(0, 1) + 1);
                        sn.addPos(new POS(1, freq));
                        freq = 1.0 / (double)(this.context.getFreq(0, 2) + 1);
                        sn.addPos(new POS(2, freq));
                        freq = 1.0 / (double)(this.context.getFreq(0, 3) + 1);
                        sn.addPos(new POS(3, freq));
                        freq = 1.0 / (double)(this.context.getFreq(0, 4) + 1);
                        sn.addPos(new POS(4, freq));
                    }
                    freq = 1.0 / (double)(this.context.getFreq(0, 11) * 8);
                    sn.addPos(new POS(11, freq));
                    freq = 1.0 / (double)(this.context.getFreq(0, 12) * 8);
                    sn.addPos(new POS(12, freq));
                    freq = 1.0 / (double)(this.context.getFreq(0, 13) * 8);
                    sn.addPos(new POS(13, freq));
                    break;
                }
                case TT_TRANS_PERSON: {
                    freq = 1.0 / (double)(this.context.getFreq(0, 0) + 1);
                    sn.addPos(new POS(0, freq));
                    if (!Utility.isAllChinese(word)) {
                        if (Utility.isAllLetter(word)) {
                            freq = 1.0 / (double)(this.context.getFreq(0, 1) + 1);
                            sn.addPos(new POS(1, freq));
                            freq = 1.0 / (double)(this.context.getFreq(0, 11) + 1);
                            sn.addPos(new POS(11, freq));
                            freq = 1.0 / (double)(this.context.getFreq(0, 2) * 2 + 1);
                            sn.addPos(new POS(2, freq));
                            freq = 1.0 / (double)(this.context.getFreq(0, 3) * 2 + 1);
                            sn.addPos(new POS(3, freq));
                            freq = 1.0 / (double)(this.context.getFreq(0, 12) * 2 + 1);
                            sn.addPos(new POS(12, freq));
                            freq = 1.0 / (double)(this.context.getFreq(0, 13) * 2 + 1);
                            sn.addPos(new POS(13, freq));
                        }
                        freq = 1.0 / (double)(this.context.getFreq(0, 41) * 8);
                        sn.addPos(new POS(41, freq));
                        freq = 1.0 / (double)(this.context.getFreq(0, 42) * 8);
                        sn.addPos(new POS(42, freq));
                        freq = 1.0 / (double)(this.context.getFreq(0, 43) * 8);
                        sn.addPos(new POS(43, freq));
                        break;
                    }
                    if (sn.getLen() >= 4) {
                        freq = 1.0 / (double)(this.context.getFreq(0, 41) * 8);
                        sn.addPos(new POS(41, freq));
                        freq = 1.0 / (double)(this.context.getFreq(0, 42) * 8);
                        sn.addPos(new POS(42, freq));
                        freq = 1.0 / (double)(this.context.getFreq(0, 43) * 8);
                        sn.addPos(new POS(43, freq));
                        break;
                    }
                    if (sn.getLen() != 2) break;
                    int charType = Utility.charType(word);
                    if (charType == 17 || charType == 7) {
                        freq = 1.0 / (double)(this.context.getFreq(0, 1) * 2 + 1);
                        sn.addPos(new POS(1, freq));
                        freq = 1.0 / (double)(this.context.getFreq(0, 2) * 2 + 1);
                        sn.addPos(new POS(2, freq));
                        freq = 1.0 / (double)(this.context.getFreq(0, 3) * 2 + 1);
                        sn.addPos(new POS(3, freq));
                        freq = 1.0 / (double)(this.context.getFreq(0, 30) * 8 + 1);
                        sn.addPos(new POS(30, freq));
                        freq = 1.0 / (double)(this.context.getFreq(0, 11) * 4 + 1);
                        sn.addPos(new POS(11, freq));
                        freq = 1.0 / (double)(this.context.getFreq(0, 12) * 4 + 1);
                        sn.addPos(new POS(12, freq));
                        freq = 1.0 / (double)(this.context.getFreq(0, 13) * 4 + 1);
                        sn.addPos(new POS(13, freq));
                        freq = 1.0 / (double)(this.context.getFreq(0, 21) * 2 + 1);
                        sn.addPos(new POS(21, freq));
                        freq = 1.0 / (double)(this.context.getFreq(0, 22) * 2 + 1);
                        sn.addPos(new POS(22, freq));
                        freq = 1.0 / (double)(this.context.getFreq(0, 23) * 2 + 1);
                        sn.addPos(new POS(23, freq));
                    }
                    freq = 1.0 / (double)(this.context.getFreq(0, 41) * 8);
                    sn.addPos(new POS(41, freq));
                    freq = 1.0 / (double)(this.context.getFreq(0, 42) * 8);
                    sn.addPos(new POS(42, freq));
                    freq = 1.0 / (double)(this.context.getFreq(0, 43) * 8);
                    sn.addPos(new POS(43, freq));
                    break;
                }
            }
            if (sn.getAllPos() != null) {
                result = sn.getAllPos().size();
            }
        }
        return result;
    }

    private void personRecognize(SegGraph segGraph, ArrayList<SegNode> sns) {
        String sPos = null;
        String personName = null;
        String[] patterns = new String[]{"BBCD", "BBC", "BBE", "BBZ", "BCD", "BEE", "BE", "BG", "BXD", "BZ", "CDCD", "CD", "EE", "FB", "Y", "XD", ""};
        double[] factor = new double[]{0.003606, 2.1E-5, 0.001314, 3.15E-4, 0.656624, 2.1E-5, 0.146116, 0.009136, 4.2E-5, 0.038971, 0.0, 0.090367, 2.73E-4, 0.009157, 0.034324, 0.009735, 0.0};
        if (segGraph != null && sns != null) {
            int j = 1;
            boolean bMatched = false;
            sPos = this.word2pattern(sns);
            while (sPos != null && j < sPos.length()) {
                bMatched = false;
                int k = 0;
                while (!bMatched && patterns[k].length() > 0) {
                    if (sPos.substring(j).indexOf(patterns[k]) == 0 && !"\u00b7".equals(sns.get(j - 1).getWord()) && !"\u00b7".equals(sns.get(j + patterns[k].length()))) {
                        String temp = sPos.substring(j + 2);
                        if (temp.length() > 1) {
                            temp = temp.substring(0, 1);
                        }
                        if (!"FB".equals(patterns[k]) || !"E".equals(temp) && !"C".equals(temp) && !"G".equals(temp)) {
                            personName = "";
                            for (int nPos = j; nPos < j + patterns[k].length(); ++nPos) {
                                SegNode sn = sns.get(nPos);
                                personName = personName + sn.getWord();
                            }
                            if ("CDCD".equals(patterns[k])) {
                                if (this.GetForeignCharCount(personName) > 0) {
                                    j += patterns[k].length() - 1;
                                }
                            } else {
                                SegNode usn = new SegNode();
                                usn.setRow(sns.get(j).getRow());
                                usn.setCol(sns.get(j + patterns[k].length() - 1).getCol());
                                usn.setWord(this.unknownFlags);
                                usn.setSrcWord(personName);
                                double value = -Math.log(factor[k]) + this.computePossibility(j, patterns[k].length(), sns);
                                usn.setPos(this.pos);
                                usn.setValue(value);
                                segGraph.setElement(usn);
                                j += patterns[k].length();
                                bMatched = true;
                            }
                        }
                    }
                    ++k;
                }
                if (bMatched) continue;
                ++j;
            }
        }
    }

    private int GetForeignCharCount(String personName) {
        return 0;
    }

    private void placeRecognize(SegGraph segGraph, ArrayList<SegNode> sns, Dictionary coreDict) {
        if (segGraph != null && coreDict != null) {
            int start = 1;
            int end = 1;
            double dPanelty = 1.0;
            String srcWord = "";
            for (int i = 1; i < sns.size(); ++i) {
                end = start = i;
                srcWord = sns.get(i).getSrcWord();
                if (this.getBestTag(sns, i) == 1) {
                    for (end = i + 1; end < sns.size(); ++end) {
                        int bestTag = this.getBestTag(sns, end);
                        if (bestTag == -1) continue;
                        if (bestTag == 1 || bestTag == 3) {
                            if (end > i + 1) {
                                dPanelty += 1.0;
                            }
                            srcWord = srcWord + sns.get(end).getSrcWord();
                            continue;
                        }
                        if (bestTag == 2) {
                            srcWord = srcWord + sns.get(end).getSrcWord();
                            continue;
                        }
                        break;
                    }
                } else if (this.getBestTag(sns, i) == 2) {
                    dPanelty += 1.0;
                    for (end = i + 1; end < sns.size(); ++end) {
                        int bestTag = this.getBestTag(sns, end);
                        if (bestTag == -1) continue;
                        if (bestTag == 3) {
                            if (end > i + 1) {
                                dPanelty += 1.0;
                            }
                            srcWord = srcWord + sns.get(end).getSrcWord();
                            continue;
                        }
                        if (bestTag == 2) {
                            srcWord = srcWord + sns.get(end).getSrcWord();
                            continue;
                        }
                        break;
                    }
                }
                if (end <= start) continue;
                SegNode newsn = new SegNode();
                newsn.setRow(sns.get(start).getRow());
                newsn.setCol(sns.get(end - 1).getCol());
                newsn.setPos(this.pos);
                newsn.setWord(this.unknownFlags);
                newsn.setSrcWord(srcWord);
                double value = this.computePossibility(start, end - start + 1, sns);
                newsn.setValue(value);
                segGraph.setElement(newsn);
            }
        }
    }

    private int getBestTag(ArrayList<SegNode> sns, int index) {
        if (sns != null && index >= 0 && index < sns.size()) {
            SegNode sn = sns.get(index);
            return this.getBestTag(sn);
        }
        return -1;
    }

    private int getBestTag(SegNode sn) {
        ArrayList<POS> allPos;
        if (sn != null && (allPos = sn.getAllPos()) != null) {
            for (POS pos : allPos) {
                if (!pos.isBest()) continue;
                return pos.getTag();
            }
        }
        return -1;
    }

    public boolean isGivenName(String sName) {
        double gnp = 0.0;
        double snp = 0.0;
        if (sName != null) {
            if (sName.getBytes().length != 4) {
                return false;
            }
            String firstChar = sName.substring(0, 1);
            String secondChar = sName.substring(1);
            gnp += Math.log((double)this.unknownDict.getFreq(firstChar, 2) + 1.0);
            gnp -= Math.log((double)this.context.getFreq(0, 2) + 1.0);
            gnp += Math.log((double)this.unknownDict.getFreq(secondChar, 3) + 1.0);
            gnp -= Math.log((double)this.context.getFreq(0, 3) + 1.0);
            gnp += Math.log(this.context.getPossibility(0, 2, 3) + 1.0);
            gnp -= Math.log((double)this.context.getFreq(0, 2) + 1.0);
            snp += Math.log((double)this.unknownDict.getFreq(firstChar, 1) + 1.0);
            snp -= Math.log((double)this.context.getFreq(0, 1) + 1.0);
            snp += Math.log((double)this.unknownDict.getFreq(secondChar, 4) + 1.0);
            snp -= Math.log((double)this.context.getFreq(0, 4) + 1.0);
            snp += Math.log(this.context.getPossibility(0, 1, 4) + 1.0);
            return !((snp -= Math.log((double)this.context.getFreq(0, 1) + 1.0)) >= gnp);
        }
        return false;
    }

    private String word2pattern(ArrayList<SegNode> sns) {
        String result = null;
        if (sns != null) {
            result = "";
            for (SegNode sn : sns) {
                result = result + (char)(this.getBestTag(sn) + 65);
            }
        }
        return result;
    }

    private void tagBest(ArrayList<SegNode> sns) {
        if (sns != null) {
            int size = sns.size();
            int j = 0;
            for (int i = size - 1; i >= 0; --i) {
                ArrayList<POS> allPos = sns.get(i).getAllPos();
                if (allPos != null && allPos.size() > j) {
                    POS pos = allPos.get(j);
                    pos.setBest(true);
                    j = pos.getPrev();
                    continue;
                }
                if (i + 1 >= size - 1) continue;
                int tag = this.getBestTag(sns.get(i + 1));
                POS pos = new POS(tag, 0.0);
                pos.setBest(true);
                sns.get(i).addPos(pos);
            }
            if (size > 1 && sns.get(size - 1).getWord() == null) {
                sns.remove(size - 1);
            }
        }
    }

    private double computePossibility(int startPos, int length, ArrayList<SegNode> sns) {
        double retValue = 0.0;
        if (sns != null && this.unknownDict != null && this.context != null) {
            for (int i = startPos; i < startPos + length && sns != null; ++i) {
                SegNode sn = sns.get(i);
                int bestTag = this.getBestTag(sn);
                if (bestTag == -1) continue;
                int freq = this.unknownDict.getFreq(sn.getSrcWord(), bestTag);
                double posPoss = Math.log(this.context.getFreq(0, sn.getPos()) + 1);
                retValue += (posPoss += -Math.log(freq + 1));
            }
        }
        return retValue;
    }

    public Dictionary getUnknownDict() {
        return this.unknownDict;
    }
}

