/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.tools.segment.bean;

import cn.pconline.search.common.tools.segment.bean.Atom;
import cn.pconline.search.common.tools.segment.bean.SegNode;
import java.util.ArrayList;

public class MidResult {
    private int index;
    private String source;
    private ArrayList<Atom> atoms;
    private ArrayList<SegNode> segGraph;
    private ArrayList<SegNode> biSegGraph;
    private ArrayList<ArrayList<Integer>> bipath;
    private ArrayList<ArrayList<SegNode>> firstSegPath;
    private ArrayList<SegNode> optSegGraph;
    private ArrayList<SegNode> optBiSegGraph;
    private ArrayList<Integer> optBipath;
    private ArrayList<SegNode> optSegPath;
    private ArrayList<SegNode> finalSegPath;

    public void setIndex(int index) {
        this.index = index;
    }

    public void setAtoms(ArrayList<Atom> atoms) {
        this.atoms = atoms;
    }

    public void setOptBiSegGraph(ArrayList<SegNode> biOptSegGraph) {
        this.optBiSegGraph = biOptSegGraph;
    }

    public void setBiSegGraph(ArrayList<SegNode> biSegGraph) {
        this.biSegGraph = biSegGraph;
    }

    public void setOptSegGraph(ArrayList<SegNode> optSegGraph) {
        this.optSegGraph = optSegGraph;
    }

    public void setSegGraph(ArrayList<SegNode> segGraph) {
        this.segGraph = segGraph;
    }

    public void setBipath(ArrayList<ArrayList<Integer>> bipath) {
        this.bipath = bipath;
    }

    public void setOptBipath(ArrayList<Integer> optBipath) {
        this.optBipath = optBipath;
    }

    public void addFirstSegPath(ArrayList<SegNode> segPath) {
        if (this.firstSegPath == null) {
            this.firstSegPath = new ArrayList();
        }
        this.firstSegPath.add(segPath);
    }

    public void setFirstSegPath(ArrayList<ArrayList<SegNode>> firstSegPath) {
        this.firstSegPath = firstSegPath;
    }

    public void setOptSegPath(ArrayList<SegNode> optSegPath) {
        this.optSegPath = optSegPath;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String toHTML() {
        StringBuffer html = new StringBuffer();
        if (this.source != null) {
            boolean flag;
            int j;
            int i;
            int height;
            int i2;
            html.append("<p>\u8fdb\u884c\u53e5\u5b50\u5206\u5272\u540e\u7684\u7ed3\u679c\uff1a");
            html.append("<table border=\"1\" width=\"100%\">");
            html.append("<tr><td width=\"10%\">\u7b2c" + this.index + "\u53e5</td>");
            html.append("<td width=\"90%\">" + this.source + "</td></tr></table>");
            if (this.atoms != null) {
                html.append("<p>\u8fdb\u884c\u539f\u5b50\u5206\u8bcd\u540e\u7684\u7ed3\u679c\uff1a");
                html.append("<table border=\"1\" width=\"100%\">");
                html.append("<tr>");
                html.append("<td width=\"10%\" bgcolor=\"#99CCFF\">\u5e8f\u53f7</td>");
                html.append("<td width=\"40%\" bgcolor=\"#99CCFF\">\u539f\u5b50</td>");
                html.append("<td width=\"25%\" bgcolor=\"#99CCFF\">\u957f\u5ea6(\u5b57\u8282)</td>");
                html.append("<td width=\"25%\" bgcolor=\"#99CCFF\">pos</td>");
                html.append("</tr>");
                for (i2 = 0; i2 < this.atoms.size(); ++i2) {
                    Atom atom = this.atoms.get(i2);
                    html.append("<tr>");
                    html.append("<td width=\"10%\">" + i2 + "</td>");
                    html.append("<td width=\"40%\">" + atom.getWord() + "</td>");
                    html.append("<td width=\"25%\">" + atom.getLen() + "</td>");
                    html.append("<td width=\"25%\">" + atom.getPos() + "</td>");
                    html.append("</tr>");
                }
                html.append("</table>");
            }
            if (this.segGraph != null && this.segGraph.size() > 0) {
                html.append("<p>\u521d\u6b21\u751f\u6210\u7684\u5206\u8bcd\u56fe\u8868\uff1a");
                html.append("<table border=\"1\" width=\"100%\">");
                html.append("<tr>");
                html.append("<td width=\"5%\"></td>");
                SegNode last = this.segGraph.get(this.segGraph.size() - 1);
                int width = last.getCol();
                height = last.getRow();
                for (i = 1; i <= width; ++i) {
                    html.append("<td width=\"" + 95.0 / (double)width + "%\" bgcolor=\"#99CCFF\">" + i + "</td>");
                }
                html.append("</tr>");
                for (i = 0; i <= height; ++i) {
                    html.append("<tr>");
                    html.append("<td width=\"5%\">" + i + "</td>");
                    for (j = 1; j <= width; ++j) {
                        flag = false;
                        for (SegNode sn : this.segGraph) {
                            if (i != sn.getRow() || j != sn.getCol()) continue;
                            html.append("<td width=\"" + 95.0 / (double)width + "%\"><a title=\"pos=" + sn.getPos() + " value=" + sn.getValue() + "\">" + sn.getWord() + "</a></td>");
                            flag = true;
                            break;
                        }
                        if (flag) continue;
                        html.append("<td width=\"" + 95.0 / (double)width + "%\">&nbsp</td>");
                    }
                    html.append("</tr>");
                }
                html.append("</table>");
            }
            if (this.biSegGraph != null && this.biSegGraph.size() > 0) {
                html.append("<p>\u521d\u6b21\u751f\u6210\u7684\u4e8c\u53c9\u5206\u8bcd\u56fe\u8868\uff1a");
                html.append("<table border=\"1\" width=\"100%\">");
                html.append("<tr>");
                html.append("<td width=\"5%\"></td>");
                SegNode last = this.biSegGraph.get(this.biSegGraph.size() - 1);
                int width = last.getCol();
                height = last.getRow();
                for (i = 1; i <= width; ++i) {
                    html.append("<td width=\"" + 95.0 / (double)width + "%\" bgcolor=\"#99CCFF\">" + i + "</td>");
                }
                html.append("</tr>");
                for (i = 0; i <= height; ++i) {
                    html.append("<tr>");
                    html.append("<td width=\"5%\">" + i + "</td>");
                    for (j = 1; j <= width; ++j) {
                        flag = false;
                        for (SegNode sn : this.biSegGraph) {
                            if (i != sn.getRow() || j != sn.getCol()) continue;
                            html.append("<td width=\"" + 95.0 / (double)width + "%\"><a title=\"pos=" + sn.getPos() + " value=" + sn.getValue() + "\">" + sn.getWord() + "</a></td>");
                            flag = true;
                            break;
                        }
                        if (flag) continue;
                        html.append("<td width=\"" + 95.0 / (double)width + "%\">&nbsp</td>");
                    }
                    html.append("</tr>");
                }
                html.append("</table>");
            }
            if (this.bipath != null && this.bipath.size() > 0) {
                html.append("<p>\u521d\u6b21\u751f\u6210\u7684\u4e8c\u53c9\u5206\u8bcd\u8def\u5f84\uff1a");
                html.append("<table border=\"1\" width=\"100%\">");
                html.append("<tr>");
                html.append("<td width=\"10%\" bgcolor=\"#99CCFF\">\u5e8f\u53f7</td>");
                html.append("<td width=\"90%\" bgcolor=\"#99CCFF\">\u4e8c\u53c9\u5206\u8bcd\u8def\u5f84</td>");
                html.append("</tr>");
                for (i2 = 0; i2 < this.bipath.size(); ++i2) {
                    html.append("<tr>");
                    html.append("<td width=\"10%\">" + i2 + "</td>");
                    html.append("<td width=\"90%\">");
                    ArrayList<Integer> list = this.bipath.get(i2);
                    for (int index : list) {
                        html.append(index + "&nbsp;");
                    }
                    html.append("</td></tr>");
                }
                html.append("</table>");
            }
            if (this.firstSegPath != null && this.firstSegPath.size() > 0) {
                html.append("<p>\u521d\u6b21\u751f\u6210\u7684\u5206\u8bcd\u7ed3\u679c\uff1a");
                html.append("<table border=\"1\" width=\"100%\">");
                html.append("<tr>");
                html.append("<td width=\"10%\" bgcolor=\"#99CCFF\">\u5e8f\u53f7</td>");
                html.append("<td width=\"90%\" bgcolor=\"#99CCFF\">\u5206\u8bcd\u7ed3\u679c</td>");
                html.append("</tr>");
                for (i2 = 0; i2 < this.firstSegPath.size(); ++i2) {
                    html.append("<tr>");
                    html.append("<td width=\"10%\">" + i2 + "</td>");
                    html.append("<td width=\"90%\" ><font color=\"#FF0000\"><b>" + MidResult.outputResult(this.firstSegPath.get(i2)) + "</b></font</td>");
                    html.append("</tr>");
                }
                html.append("</table>");
            }
            if (this.optSegGraph != null && this.optSegGraph.size() > 0) {
                html.append("<p>\u7ecf\u8fc7\u4eba\u540d\u3001\u5730\u540d\u8bc6\u522b\u540e\u7684\u5206\u8bcd\u56fe\u8868\uff1a");
                html.append("<table border=\"1\" width=\"100%\">");
                html.append("<tr>");
                html.append("<td width=\"5%\"></td>");
                SegNode last = this.optSegGraph.get(this.optSegGraph.size() - 1);
                int width = last.getCol();
                height = last.getRow();
                for (i = 1; i <= width; ++i) {
                    html.append("<td width=\"" + 95.0 / (double)width + "%\" bgcolor=\"#99CCFF\">" + i + "</td>");
                }
                html.append("</tr>");
                for (i = 0; i <= height; ++i) {
                    html.append("<tr>");
                    html.append("<td width=\"5%\">" + i + "</td>");
                    for (j = 1; j <= width; ++j) {
                        flag = false;
                        for (SegNode sn : this.optSegGraph) {
                            if (i != sn.getRow() || j != sn.getCol()) continue;
                            html.append("<td width=\"" + 95.0 / (double)width + "%\"><a title=\"pos=" + sn.getPos() + " value=" + sn.getValue() + "\">" + sn.getWord() + "</a></td>");
                            flag = true;
                            break;
                        }
                        if (flag) continue;
                        html.append("<td width=\"" + 95.0 / (double)width + "%\">&nbsp</td>");
                    }
                    html.append("</tr>");
                }
                html.append("</table>");
            }
            if (this.optBiSegGraph != null && this.optBiSegGraph.size() > 0) {
                html.append("<p>\u7ecf\u8fc7\u4f18\u5316\u540e\u7684\u4e8c\u53c9\u5206\u8bcd\u56fe\u8868\uff1a");
                html.append("<table border=\"1\" width=\"100%\">");
                html.append("<tr>");
                html.append("<td width=\"5%\"></td>");
                SegNode last = this.optBiSegGraph.get(this.optBiSegGraph.size() - 1);
                int width = last.getCol();
                height = last.getRow();
                for (i = 1; i <= width; ++i) {
                    html.append("<td width=\"" + 95.0 / (double)width + "%\" bgcolor=\"#99CCFF\">" + i + "</td>");
                }
                html.append("</tr>");
                for (i = 0; i <= height; ++i) {
                    html.append("<tr>");
                    html.append("<td width=\"5%\">" + i + "</td>");
                    for (j = 1; j <= width; ++j) {
                        flag = false;
                        for (SegNode sn : this.optBiSegGraph) {
                            if (i != sn.getRow() || j != sn.getCol()) continue;
                            html.append("<td width=\"" + 95.0 / (double)width + "%\"><a title=\"pos=" + sn.getPos() + " value=" + sn.getValue() + "\">" + sn.getWord() + "</a></td>");
                            flag = true;
                            break;
                        }
                        if (flag) continue;
                        html.append("<td width=\"" + 95.0 / (double)width + "%\">&nbsp</td>");
                    }
                    html.append("</tr>");
                }
                html.append("</table>");
            }
            if (this.optBipath != null && this.optBipath.size() > 0) {
                html.append("<p>\u7ecf\u8fc7\u4f18\u5316\u540e\u7684\u4e8c\u53c9\u5206\u8bcd\u8def\u5f84\uff1a");
                html.append("<table border=\"1\" width=\"100%\">");
                html.append("<tr>");
                html.append("<td width=\"90%\" bgcolor=\"#99CCFF\">\u4e8c\u53c9\u5206\u8bcd\u8def\u5f84</td>");
                html.append("</tr>");
                html.append("<tr>");
                html.append("<td width=\"90%\">");
                ArrayList<Integer> list = this.optBipath;
                for (int index : list) {
                    html.append(index + "&nbsp;");
                }
                html.append("</td></tr>");
                html.append("</table>");
            }
            if (this.optSegPath != null && this.optSegPath.size() > 0) {
                html.append("<p>\u7ecf\u8fc7\u4f18\u5316\u540e\u7684\u5206\u8bcd\u7ed3\u679c\uff1a");
                html.append("<table border=\"1\" width=\"100%\">");
                html.append("<tr>");
                html.append("<td width=\"90%\" bgcolor=\"#99CCFF\">\u5206\u8bcd\u7ed3\u679c</td>");
                html.append("</tr>");
                html.append("<tr>");
                html.append("<td width=\"90%\" ><font color=\"#FF0000\"><b>" + MidResult.outputResult(this.optSegPath) + "</b></font</td>");
                html.append("</tr>");
                html.append("</table>");
            }
            if (this.finalSegPath != null && this.finalSegPath.size() > 0) {
                html.append("<p>\u672c\u53e5\u6700\u7ec8\u7684\u5206\u8bcd\u7ed3\u679c\uff1a");
                html.append("<table border=\"1\" width=\"100%\">");
                html.append("<tr>");
                html.append("<td width=\"90%\" bgcolor=\"#99CCFF\">\u5206\u8bcd\u7ed3\u679c</td>");
                html.append("</tr>");
                html.append("<tr>");
                html.append("<td width=\"90%\" ><font color=\"#FF0000\"><b>" + MidResult.outputResult(this.finalSegPath) + "</b></font</td>");
                html.append("</tr>");
                html.append("</table>");
            }
        }
        return html == null ? null : html.toString();
    }

    public static String outputResult(ArrayList<SegNode> wrList) {
        String result = null;
        String temp = null;
        char[] pos = new char[2];
        if (wrList != null && wrList.size() > 0) {
            result = "";
            for (int i = 0; i < wrList.size(); ++i) {
                SegNode sn = wrList.get(i);
                if (sn.getPos() == 1 || sn.getPos() == 4) continue;
                int tag = Math.abs(sn.getPos());
                pos[0] = (char)(tag / 256);
                pos[1] = (char)(tag % 256);
                temp = "" + pos[0];
                if (pos[1] > '\u0000') {
                    temp = temp + "" + pos[1];
                }
                result = result + sn.getSrcWord() + "/" + temp + " ";
            }
        }
        return result;
    }

    public ArrayList<SegNode> getFinalSegPath() {
        return this.finalSegPath;
    }

    public void setFinalSegPath(ArrayList<SegNode> finalSegPath) {
        this.finalSegPath = finalSegPath;
    }

    public ArrayList<SegNode> getOptSegPath() {
        return this.optSegPath;
    }

    public String getSource() {
        return this.source;
    }
}

