/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.util;

import cn.pconline.search.common.util.LRULinkedHashMap;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class Cache {
    private Map lhm;
    private int maxSize;
    private AtomicLong version = new AtomicLong(0L);

    public void setVersion(long version) {
        this.version.set(version);
    }

    public long getVersion() {
        return this.version.get();
    }

    public Cache(int size) {
        this.lhm = Collections.synchronizedMap(new LRULinkedHashMap(size));
        this.maxSize = size;
    }

    public void clear() {
        this.lhm.clear();
    }

    public void add(String key, Object value) {
        if (key != null && key.trim().length() > 0 && value != null) {
            this.lhm.put(key, value);
        }
    }

    public Object get(String key) {
        return this.lhm.get(key);
    }

    public int size() {
        return this.lhm.size();
    }

    public int getMaxSize() {
        return this.maxSize;
    }
}

