/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.util;

import java.math.BigDecimal;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class QueryUtil {
    public static String toDismaxQuery(String keyword, Map<String, Float> boostMap) {
        StringBuilder builder = new StringBuilder();
        builder.append("_query_:\"{!edismax qf='");
        for (Map.Entry<String, Float> en : boostMap.entrySet()) {
            builder.append(en.getKey()).append("^").append(new BigDecimal(en.getValue().floatValue()).toPlainString()).append(" ");
        }
        builder.append("'}").append(QueryUtil.escapeQStr(keyword));
        return builder.toString();
    }

    public static String escapeQStr(String query) {
        if (StringUtils.isEmpty((String)query)) {
            return query;
        }
        query = query.trim();
        query = query.replace("\"", "\\\"");
        query = query.replace("+", "\\+");
        query = query.replace("-", "\\-");
        query = query.replace("(", "\\(");
        query = query.replace(")", "\\)");
        query = query.replace("^", "\\^");
        query = query.replace("OR", "\\OR");
        query = query.replace("AND", "\\AND");
        query = query.replace("NOT", "\\NOT");
        return query;
    }

    public static boolean shouldUsePharse(String input) {
        if (StringUtils.isBlank((String)input)) {
            return false;
        }
        input = input.trim();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (Character.isSpaceChar(input.charAt(i)) || Character.isWhitespace(input.charAt(i))) {
                return false;
            }
            if (Character.isDigit(input.charAt(i)) || Character.isUpperCase(c) || Character.isLowerCase(c) || input.charAt(i) == '_' || input.charAt(i) == '-') continue;
            return false;
        }
        return true;
    }
}

