/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.tools.segment.utility;

import cn.pconline.search.common.tools.segment.utility.GFString;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class GFCommon {
    public static int bytesCopy(byte[] d, byte[] s, int from, int maxlen) {
        int end;
        block5: {
            block6: {
                end = from;
                if (s == null || d == null) break block5;
                if (from < 0 || maxlen <= 0) break block6;
                if (s.length < maxlen) {
                    for (int i = 0; i < s.length && i + from < d.length; ++i) {
                        d[i + from] = s[i];
                    }
                    end = from + maxlen - 1;
                } else {
                    for (int i = 0; i < maxlen && i + from < d.length; ++i) {
                        d[i + from] = s[i];
                        end = i + from;
                    }
                }
                break block5;
            }
            if (from >= 0 || maxlen <= 0) break block5;
            int i = d.length + from;
            for (int j = 0; i > 0 && j < (s.length > maxlen ? maxlen : s.length); ++j) {
                d[i] = s[j];
                end = i--;
            }
        }
        return end;
    }

    public static byte[] bytesCopy(byte[] src, int from, int len) {
        byte[] result;
        block4: {
            result = null;
            int totalLen = 0;
            if (src == null || src.length <= 0 || len <= 0) break block4;
            if (from >= 0) {
                totalLen = src.length > from + len ? len : src.length - from;
                result = new byte[Math.abs(len)];
                int i = from;
                int j = 0;
                while (i < from + totalLen) {
                    result[j] = src[i];
                    ++i;
                    ++j;
                }
            } else {
                int i0 = src.length + from;
                totalLen = i0 - len < 0 ? i0 + 1 : len;
                result = new byte[totalLen];
                int i = i0;
                for (int j = 0; i >= 0 && j < totalLen; --i, ++j) {
                    result[j] = src[i];
                }
            }
        }
        return result;
    }

    public static byte[] int2bytes(int a, boolean isHighFirst) {
        byte[] result = new byte[4];
        if (isHighFirst) {
            result[0] = (byte)(a >> 24 & 0xFF);
            result[1] = (byte)(a >> 16 & 0xFF);
            result[2] = (byte)(a >> 8 & 0xFF);
            result[3] = (byte)(a & 0xFF);
        } else {
            result[3] = (byte)(a >> 24 & 0xFF);
            result[2] = (byte)(a >> 16 & 0xFF);
            result[1] = (byte)(a >> 8 & 0xFF);
            result[0] = (byte)(a & 0xFF);
        }
        return result;
    }

    public static byte[] int2bytes(int a) {
        return GFCommon.int2bytes(a, true);
    }

    public static String getClassName(Object obj) {
        String name = null;
        if (obj != null) {
            int index = 0;
            String temp = obj.getClass().toString();
            index = temp.lastIndexOf(".");
            if (index > 0 && index < temp.length()) {
                name = temp.substring(index + 1);
            }
        }
        return name;
    }

    public static int bytes2int(byte[] b) {
        return (int)GFCommon.bytes2long(b);
    }

    public static int bytes2int(byte[] b, boolean isHighFirst) {
        return (int)GFCommon.bytes2long(b, isHighFirst);
    }

    public static long bytes2long(byte[] b) {
        return GFCommon.bytes2long(b, true);
    }

    public static long bytes2long(byte[] b, boolean isHighFirst) {
        long result;
        block4: {
            result = 0L;
            if (b == null || b.length > 8) break block4;
            if (isHighFirst) {
                int i = b.length - 1;
                int j = 0;
                while (i >= 0) {
                    long value = b[i] & 0xFF;
                    result += value << (j << 3);
                    --i;
                    ++j;
                }
            } else {
                int i = 0;
                int j = 0;
                while (i < b.length - 1) {
                    long value = b[i] & 0xFF;
                    result += value << (j << 3);
                    ++i;
                    ++j;
                }
            }
        }
        return result;
    }

    public static String byte2bin(byte b) {
        String result = "";
        for (int i = 0; i < 8; ++i) {
            result = (b >>> 7 - i & 1) == 0 ? result + "0" : result + "1";
        }
        return result;
    }

    public static String int2bin(int value) {
        String result = "";
        for (int i = 0; i < 32; ++i) {
            if ((value >>> 31 - i & 1) == 0) {
                if (result.length() == 0) continue;
                result = result + "0";
                continue;
            }
            result = result + "1";
        }
        if (result.length() == 0) {
            result = "0";
        }
        return result;
    }

    public static String long2bin(long value) {
        String result = "";
        for (int i = 0; i < 64; ++i) {
            result = (value >>> 63 - i & 1L) == 0L ? result + "0" : result + "1";
        }
        return result;
    }

    public static byte[] long2bytes(long value) {
        return GFCommon.long2bytes(value, true);
    }

    public static byte[] long2bytes(long value, boolean isHighFirst) {
        byte[] b = new byte[8];
        if (isHighFirst) {
            for (int i = 0; i < 8; ++i) {
                b[i] = (byte)(value >> 8 * (7 - i) & 0xFFL);
            }
        } else {
            int i = 0;
            int j = 7;
            while (i < 8) {
                b[j] = (byte)(value >> 8 * (7 - i) & 0xFFL);
                ++i;
                --j;
            }
        }
        return b;
    }

    public static String formatIP(String ip) {
        String result = null;
        if (ip != null) {
            String[] p = new String[4];
            int index = ip.indexOf(".");
            if (index <= 0 || index >= ip.length() - 1) {
                return null;
            }
            p[0] = ip.substring(0, index);
            ip = ip.substring(index + 1);
            index = ip.indexOf(".");
            if (index <= 0 || index >= ip.length() - 1) {
                return null;
            }
            p[1] = ip.substring(0, index);
            ip = ip.substring(index + 1);
            index = ip.indexOf(".");
            if (index <= 0 || index >= ip.length() - 1) {
                return null;
            }
            p[2] = ip.substring(0, index);
            p[3] = ip.substring(index + 1);
            if (p != null && p.length == 4) {
                result = GFString.getFixedLenStr(p[0], 3, '0');
                result = result + GFString.getFixedLenStr(p[1], 3, '0');
                result = result + GFString.getFixedLenStr(p[2], 3, '0');
                result = result + GFString.getFixedLenStr(p[3], 3, '0');
            }
        }
        return result;
    }

    public static boolean isActiveThread(ThreadGroup group, String threadName) {
        if (group != null && threadName != null) {
            Thread[] thd = new Thread[group.activeCount()];
            group.enumerate(thd);
            String name = null;
            for (int i = 0; i < thd.length && thd[i] != null; ++i) {
                name = thd[i].getName();
                if (name == null || !name.equals(threadName)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getSystemInfo() {
        String result = "os.name:" + System.getProperty("os.name") + "\n" + "os.arch:" + System.getProperty("os.arch") + "\n\n" + "java.vendor:" + System.getProperty("java.vendor") + "\n" + "java.home:" + System.getProperty("java.home") + "\n" + "java.version:" + System.getProperty("java.version") + "\n" + "java.vm.version:" + System.getProperty("java.vm.version") + "\n\n" + "user.name:" + System.getProperty("user.name") + "\n" + "user.dir:" + System.getProperty("user.dir");
        return result;
    }

    public static Connection getConn(String driver, String url, String userName, String pwd) {
        Connection conn = null;
        if (driver != null && url != null && userName != null && pwd != null) {
            try {
                Class.forName(driver);
                conn = DriverManager.getConnection(url, userName, pwd);
                if (conn != null) {
                    String str = "\u5efa\u7acb\u548c\u8fdc\u7a0b\u6570\u636e\u5e93\u7684\u8fde\u63a5!";
                    System.out.println(str);
                }
            }
            catch (ClassNotFoundException e) {
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return conn;
    }

    public static String getClassPath(String className) {
        try {
            return Class.forName(className).getClassLoader().getResource("").getPath();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getClassPath(Object objName) {
        return objName.getClass().getClassLoader().getResource("").getPath();
    }

    public static String getWebinfPath(String classPath) {
        String path = null;
        if (classPath != null) {
            String[] strs = classPath.split("/");
            path = "";
            for (int i = 1; i < strs.length - 1; ++i) {
                if (strs[i] == null) continue;
                path = path + strs[i] + System.getProperty("file.separator");
            }
        }
        return path;
    }

    public static int random(int seed) {
        long result = 0L;
        if (seed != 0) {
            double d = Math.random();
            String temp = d + "";
            int len = temp.length() - 2;
            result = (long)(d *= Math.pow(10.0, len)) % (long)seed;
        }
        return (int)result;
    }

    public static int random(int min, int max) {
        int rd = GFCommon.random(max);
        if (rd >= min) {
            return rd;
        }
        return GFCommon.random(min, max);
    }

    public static int getZeroIndex(byte[] b) {
        if (b != null) {
            for (int i = 0; i < b.length; ++i) {
                if (b[i] != 0) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean isHasZero(byte[] b) {
        if (b == null) {
            return true;
        }
        for (byte b1 : b) {
            if (b1 != 0) continue;
            return true;
        }
        return false;
    }

    public static int getUnsigned(byte b) {
        if (b > 0) {
            return b;
        }
        return b & 0xFF;
    }
}

