/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.util;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public final class HttpUrl
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -6206126100089936640L;
    private Params params = new Params();
    private String host;
    private int port;
    private boolean isHttps = false;
    private String requestUri;
    private String paramsEncoding = "gbk";

    public HttpUrl() {
    }

    public HttpUrl(String host, int port, String requestUri) {
        this.host = host;
        this.port = port;
        this.requestUri = requestUri;
    }

    public HttpUrl(String host, int port, String requestUri, String paramsEncoding) {
        this.host = host;
        this.port = port;
        this.requestUri = requestUri;
        this.paramsEncoding = paramsEncoding;
    }

    public String getParamsEncoding() {
        return this.paramsEncoding;
    }

    public void setParamsEncoding(String paramsEncoding) {
        this.paramsEncoding = paramsEncoding;
    }

    public Params getParams() {
        return this.params;
    }

    public void setParamString(String paramString) {
        if (StringUtils.isBlank((String)paramString)) {
            return;
        }
        String[] kvPair = paramString.split("\\s?\\&\\s?");
        if (kvPair == null || kvPair.length == 0) {
            return;
        }
        String value = null;
        for (String kv : kvPair) {
            String[] arr = kv.split("\\s?=\\s?", 2);
            if (arr == null || arr.length != 2 || !StringUtils.isNotBlank((String)arr[0]) || !StringUtils.isNotBlank((String)arr[1])) continue;
            try {
                value = URLDecoder.decode(arr[1].trim(), this.paramsEncoding);
            }
            catch (UnsupportedEncodingException e) {
                continue;
            }
            this.setParam(arr[0].trim(), value, false);
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public void setRequestUri(String requestUri) {
        this.requestUri = requestUri;
    }

    public boolean isHttps() {
        return this.isHttps;
    }

    public void setHttps(boolean isHttps) {
        this.isHttps = isHttps;
    }

    public HttpUrl setParam(String key, Object value, boolean replace) {
        String[] values = (String[])this.params.get(key);
        if (values == null || replace) {
            values = new String[1];
        } else {
            String[] temp = new String[values.length + 1];
            System.arraycopy(values, 0, temp, 0, values.length);
            values = temp;
        }
        values[values.length - 1] = value.toString();
        this.params.put(key, values);
        return this;
    }

    public String getParam(String key) {
        String[] arr = (String[])this.params.get(key);
        if (arr != null && arr.length > 0) {
            return arr[0];
        }
        return null;
    }

    public HttpUrl clearAllParams() {
        this.params.clear();
        return this;
    }

    public HttpUrl removeParam(String key) {
        this.params.remove(key);
        return this;
    }

    public HttpUrl replaceParam(String key, Object ... values) {
        if (ArrayUtils.isNotEmpty((Object[])values)) {
            if (values.length == 1 && values[0] == null) {
                return this;
            }
            String[] vs = new String[values.length];
            for (int i = 0; i < vs.length; ++i) {
                vs[i] = values[i].toString();
            }
            this.params.put(key, vs);
        }
        return this;
    }

    public void setHostAndPort(String hostPortStr) {
        if (StringUtils.isBlank((String)hostPortStr)) {
            throw new IllegalArgumentException("hostPortStr");
        }
        if (hostPortStr.indexOf(":") > 0) {
            this.setHost(hostPortStr.substring(0, hostPortStr.indexOf(":")));
            this.setPort(Integer.parseInt(hostPortStr.substring(hostPortStr.indexOf(":") + 1)));
        } else {
            this.setHost(hostPortStr);
            this.setPort(80);
        }
    }

    public HttpUrl copy() {
        HttpUrl holder = new HttpUrl(this.host, this.port, this.requestUri, this.paramsEncoding);
        for (Map.Entry en : this.params.entrySet()) {
            String[] arr = new String[((String[])en.getValue()).length];
            System.arraycopy(en.getValue(), 0, arr, 0, ((String[])en.getValue()).length);
            holder.params.put(en.getKey(), arr);
        }
        return holder;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.isHttps) {
            builder.append("https://");
        } else {
            builder.append("http://");
        }
        builder.append(this.host);
        if (this.isHttps) {
            if (this.port != 443) {
                builder.append(":").append(this.port);
            }
        } else if (this.port != 80) {
            builder.append(":").append(this.port);
        }
        if (!this.requestUri.startsWith("/")) {
            builder.append("/");
        }
        builder.append(this.requestUri);
        String paramStr = null;
        try {
            paramStr = this.params.toString(true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (StringUtils.isNotEmpty(paramStr)) {
            builder.append("?").append(paramStr);
        }
        return builder.toString();
    }

    public static HttpUrl fromHttpRequest(HttpServletRequest req, String ... ignoreKeys) {
        String pageUri = req.getRequestURI();
        if (pageUri == null) {
            pageUri = "/";
        }
        HttpUrl holder = new HttpUrl(req.getServerName(), req.getServerPort(), pageUri);
        Map params = req.getParameterMap();
        if (params == null) {
            return holder;
        }
        for (Map.Entry en : params.entrySet()) {
            if (ignoreKeys != null) {
                boolean ignore = false;
                for (String key : ignoreKeys) {
                    if (!((String)en.getKey()).equals(key)) continue;
                    ignore = true;
                    break;
                }
                if (ignore) continue;
            }
            holder.getParams().put(en.getKey(), en.getValue());
        }
        return holder;
    }

    public static HttpUrl fromUrl(String url, String paramEncoding) {
        URL u = null;
        try {
            u = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("illegal url string:" + url, e);
        }
        String protocol = u.getProtocol();
        if (!"http".equalsIgnoreCase(u.getProtocol()) && !"https".equalsIgnoreCase(protocol)) {
            throw new IllegalArgumentException("illegal http protocol:" + protocol);
        }
        HttpUrl holder = new HttpUrl();
        holder.setHttps("https".equalsIgnoreCase(protocol));
        holder.setHost(u.getHost());
        holder.setPort(u.getPort() == -1 ? u.getDefaultPort() : u.getPort());
        holder.setRequestUri(u.getPath());
        if (StringUtils.isNotEmpty((String)paramEncoding)) {
            holder.setParamsEncoding(paramEncoding);
        }
        try {
            holder.getParams().addParamFromString(u.getQuery(), paramEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("unsupported url param encoding:" + paramEncoding, e);
        }
        return holder;
    }

    public class Params
    extends LinkedHashMap<String, String[]> {
        private static final long serialVersionUID = -890157917077460545L;

        Params() {
        }

        private Params(int capacity) {
            super(capacity);
        }

        void addParamFromString(String qString, String encoding) throws UnsupportedEncodingException {
            if (StringUtils.isBlank((String)qString)) {
                return;
            }
            Object[] pairs = (qString = qString.trim()).split("&");
            if (ArrayUtils.isEmpty((Object[])pairs)) {
                return;
            }
            for (Object param : pairs) {
                Object[] arr = ((String)param).split("=", 2);
                if (ArrayUtils.isEmpty((Object[])arr) || arr.length != 2) continue;
                HttpUrl.this.setParam((String)arr[0], StringUtils.isEmpty((String)encoding) ? arr[1] : URLDecoder.decode((String)arr[1], HttpUrl.this.paramsEncoding), false);
            }
        }

        public String toString(boolean encode) throws UnsupportedEncodingException {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry en : this.entrySet()) {
                for (String value : (String[])en.getValue()) {
                    builder.append((String)en.getKey());
                    builder.append("=");
                    if (encode) {
                        builder.append(URLEncoder.encode(value, HttpUrl.this.paramsEncoding));
                    } else {
                        builder.append(value);
                    }
                    builder.append("&");
                }
            }
            if (builder.length() > 0) {
                builder.delete(builder.length() - 1, builder.length());
            }
            return builder.toString();
        }

        @Override
        public Object clone() {
            Params params = new Params(this.size());
            for (Map.Entry en : this.entrySet()) {
                String[] arr = new String[((String[])en.getValue()).length];
                System.arraycopy(en.getValue(), 0, arr, 0, ((String[])en.getValue()).length);
                params.put(en.getKey(), arr);
            }
            return params;
        }

        @Override
        public String toString() {
            try {
                return this.toString(false);
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
    }
}

