package cn.pconline.search.common.query;

import java.util.Iterator;

import org.apache.solr.common.params.ModifiableSolrParams;

import cn.pconline.search.common.util.QueryUtil;

/**
 * 内嵌查询支持
 * 
 * @author zengjie
 * @since 2013-9-25
 * @see
 */
public class NestedQuery extends ModifiableSolrParams
{

    private static final long serialVersionUID = 5972829976535150362L;

    private Object q;

    private Operator operator = Operator.SHOULD;

    private String defType;

    public Operator getOperator()
    {
        return operator;
    }

    public void setOperator(Operator operator)
    {
        this.operator = operator;
    }

    public String getDefType()
    {
        return defType;
    }

    public void setDefType(String defType)
    {
        this.defType = defType;
    }

    public void setQ(Q q)
    {
        this.q = q;
    }

    public void setQ(String q)
    {
        this.q = q;
    }

    public Object getQ()
    {
        return q;
    }

    @Override
    public String toString()
    {
        StringBuilder sb = new StringBuilder();
        sb.append(operator);
        sb.append("_query_:\"");
        sb.append("{!" + defType + " ");
        Iterator<String> it = super.getParameterNamesIterator();
        while (it.hasNext())
        {
            String key = it.next();
            String[] vals = super.getParams(key);
            if (vals == null || vals.length == 0)
            {
                continue;
            }
            for (String s : vals)
            {
                sb.append(key + "='");
                sb.append(s);
                sb.append("' ");
            }
        }
        sb.append("}");
        if (q instanceof String)
        {
            sb.append(QueryUtil.escapeQStr(q.toString()));
        }
        else
        {
            sb.append(q);
        }
        sb.append("\"");
        return sb.toString();
    }
}
