package cn.pconline.search.common.taglib;

import javax.servlet.jsp.JspException;

import org.apache.log4j.Logger;

import cn.pconline.search.common.util.Intf;

/**
 * 通过HTTP调用指定url获取html文本，写入到当前jsp页面
 * 
 * @author zengjie
 * @since 2013-9-18
 * @see
 */
public class SsiTag extends BaseTag
{

    private static Logger logger = Logger.getLogger(SsiTag.class);

    private static final long serialVersionUID = 2656859065673648605L;

    private String url;

    @Override
    public int doStartTag() throws JspException
    {
        String useProxy = "n";
        String content = "";
        if (url == null)
        {
            url = "";
        }
        content = readHtml(useProxy);
        if (content == null) content = "";
        writeToOut(content);

        return SKIP_BODY;
    }

    protected String readHtml(String useProxy)
    {
        try
        {
            return Intf.readHtml4Get(url,
                    "y".equals(useProxy) ? Intf.DEFAULT_PROXY_CONFIG : null,
                    "GBK", 30000, 0); // 3秒超时
        }
        catch (Exception e)
        {
            logger.error("read html error", e);
            return "<!-- include tag error:" + e.getMessage() + " -->";
        }
    }

    public void setUrl(String url)
    {
        this.url = url;
    }

}
