package cn.pconline.search.common.util;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;

/**
 * 对HttpServlet的属性封装
 * 
 * @author zengjie
 * @since 2013-11-20
 * @see javax.servlet.http.HttpServletRequestWrapper
 */
public class HttpServletRequestWrapper extends
        javax.servlet.http.HttpServletRequestWrapper
{

    private Map<String, Object> attributeMap = new HashMap<String, Object>();

    private Set<String> deleteKeyList = new HashSet<String>();

    public HttpServletRequestWrapper(HttpServletRequest request)
    {
        super(request);
    }

    /**
     * 将所有的属性操作应用到目标Request对象
     */
    public void applyAttributes()
    {
        // ServletRequest target = getRequest();
        if (deleteKeyList.size() > 0)
        {
            for (String key : deleteKeyList)
            {
                super.removeAttribute(key);
            }
        }
        if (attributeMap.size() > 0)
        {
            for (Entry<String, Object> e : attributeMap.entrySet())
            {
                super.setAttribute(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public void setAttribute(String name, Object o)
    {
        if (o == null)
        {
            this.removeAttribute(name);
        }
        else
        {
            deleteKeyList.remove(name);
            attributeMap.put(name, o);
        }
    }

    @Override
    public Object getAttribute(String name)
    {
        if (deleteKeyList.contains(name))
        {
            return null;
        }
        Object v = this.getAttribute(name);
        if (v == null)
        {
            v = super.getAttribute(name);
        }
        return v;
    }

    @Override
    public Enumeration getAttributeNames()
    {
        final Enumeration<Object> e = super.getAttributeNames();
        final Iterator<String> it = this.attributeMap.keySet().iterator();
        return new Enumeration<Object>()
        {

            Object current = null;

            public boolean hasMoreElements()
            {
                if (current != null)
                {
                    return true;
                }
                if (it.hasNext())
                {
                    return true;
                }
                while (true)
                {
                    current = null;
                    if (e.hasMoreElements())
                    {
                        current = e.nextElement();
                        if (deleteKeyList.contains(current))
                        {
                            continue;
                        }
                        return true;
                    }
                    return false;
                }
            }

            public Object nextElement()
            {
                Object next = null;
                if (current != null)
                {
                    next = current;
                    current = null;
                    return next;
                }
                if (it.hasNext())
                {
                    return it.next();
                }
                next = e.nextElement();
                if (deleteKeyList.contains(next))
                {
                    return nextElement();
                }
                return next;
            }
        };
    }

    @Override
    public void removeAttribute(String name)
    {
        this.attributeMap.remove(name);
        deleteKeyList.add(name);
    }

}
