/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.tools.generalization2;

import cn.pconline.search.common.tools.generalization2.SingleDimension;
import cn.pconline.search.common.tools.semantic2.SemanticResult;
import cn.pconline.search.common.tools.semantic2.SemanticWord;
import java.util.HashMap;
import java.util.Map;

public class Dimensions {
    private Map<String, SingleDimension> dimensionMap = new HashMap<String, SingleDimension>();

    public void addDimension(SingleDimension dimension) {
        this.dimensionMap.put(dimension.getField(), dimension);
    }

    public SingleDimension getDimension(String field) {
        return this.dimensionMap.get(field);
    }

    public Map<String, SingleDimension> getDimensionMap() {
        return this.dimensionMap;
    }

    public String toString() {
        return "Dimensions [dimensionMap=" + this.dimensionMap + "]";
    }

    public String toSolrQuery(boolean filterAll) {
        if (this.dimensionMap.isEmpty()) {
            return "";
        }
        StringBuilder content = new StringBuilder();
        int index = 0;
        for (Map.Entry<String, SingleDimension> en : this.dimensionMap.entrySet()) {
            if (index != 0) {
                content.append(" ");
            }
            ++index;
            SemanticResult result = en.getValue().getFilter();
            content.append((filterAll ? "+" : "") + en.getValue().getField() + ":(");
            for (SemanticWord word : result.getWords()) {
                content.append(word.getWord()).append("^").append(word.getBoost()).append(" ");
            }
            content.append(")");
        }
        return content.toString();
    }
}

